#include "mbed.h"
#include "PCF8591.h"
 
Serial pc(USBTX, USBRX); // tx, rx

DigitalOut redLED(D0);
DigitalOut greenLED(D1);
 
PCF8591 adc;

static void experiment1()
{
    // set wanted duty cycle
    int wantedDutyCycle = 10;
    
    // initialize LEDs to off
    greenLED = redLED = 1;

    pc.printf("Fixed duty cycle\n");
    while(1) {
        // set output high
        greenLED = 1;
        
        for (int loopCounter = 0; loopCounter < 100; loopCounter++) {
            if (loopCounter == wantedDutyCycle) {
                // set output low
                greenLED = 0;
            }
        }
    }
}

static int getDutyCycle(PCF8591::AnalogIn port)
{
    return (adc.read(port) * 100)/256;
}

static void experiment2()
{
    // set wanted duty cycle
    int wantedDutyCycle = 10;

    // initialize LEDs to off
    greenLED = redLED = 1;

    pc.printf("Trimpot controlled duty cycle\n");
    while(1) {
        wantedDutyCycle = getDutyCycle(PCF8591::A0);
        
        // The duty cycle does not have to be read for each PWM loop
        for (int num = 0; num < 200; num++) {
            // set output high
            greenLED = 1;
            
            for (int loopCounter = 0; loopCounter < 100; loopCounter++) {
                if (loopCounter == wantedDutyCycle) {
                    // set output low
                    greenLED = 0;
                }
            }
        }
    }
}

static void experiment3()
{
    // set wanted duty cycle
    int wantedDutyCycle = 10;
    
    // set wanted frequency
    int delay = 1;

    // initialize LEDs to off
    greenLED = redLED = 1;

    bool readDuty = true;

    pc.printf("Trimpot controlled duty cycle and frequency\n");
    while(1) {
        // Don't want to read too often as that will return incorrect values
        if (readDuty) {
            wantedDutyCycle = getDutyCycle(PCF8591::A0);
        } else {
            delay = getDutyCycle(PCF8591::A1);
        }
        readDuty = !readDuty;
        
        // Try to run PWM loop for about 50ms to allow ADC to produce correct values
        for (int num = 0; num <= (500/(delay+1)); num++) {
            // set output high
            greenLED = 1;

            for (int loopCounter = 0; loopCounter < 100; loopCounter++) {
                if (loopCounter == wantedDutyCycle) {
                    // set output low
                    greenLED = 0;
                }
                wait_us(delay*5);
            }
        }        
    }
}

static void experiment4()
{
    // set wanted duty cycle
    int wantedRedDutyCycle = 10;
    int wantedGreenDutyCycle = 10;
    
    bool readRed = true;
    
    // initialize LEDs to off
    greenLED = redLED = 1;

    pc.printf("Trimpot controlled duty cycle (one per LED)\n");
    while(1) {
        if (readRed) {
            wantedRedDutyCycle = getDutyCycle(PCF8591::A0);
        } else {
            wantedGreenDutyCycle = getDutyCycle(PCF8591::A1);
        }
        readRed = !readRed;
        

        // The duty cycle does not have to be read for each PWM loop
        for (int num = 0; num < 200; num++) {
            // set outputs high
            greenLED = 1;
            redLED = 1;
        
            for (int loopCounter = 0; loopCounter < 100; loopCounter++) {
                if (loopCounter == wantedGreenDutyCycle) {
                    // set output low
                    greenLED = 0;
                }
                if (loopCounter == wantedRedDutyCycle) {
                    // set output low
                    redLED = 0;
                }
            }
        }
    }
}

int main()
{
    //experiment1();  // Fixed duty cycle
    //experiment2();  // Trimpot controlled duty cycle
    //experiment3();  // Trimpots controls duty cycle and frequency
    experiment4();  // Trimpots controls one LED each
}