#include "mbed.h"

DigitalIn button1(D0);
DigitalIn button2(D1);
DigitalIn button3(D3);

DigitalOut led1(D8);
DigitalOut led2(D9);
DigitalOut led3(D10);
DigitalOut led4(D11);
DigitalOut led5(D12);
DigitalOut led6(D13);

static void experiment1_alt1()
{
    int state = 0;

    // Set LED start values
    led1 = 1;
    led2 = 1;
    led3 = 1;
    led4 = 1;
    led5 = 1;
    led6 = 1;
    
    // Enable buttons
    button1.mode(PullUp);
 
    // Enter forever loop
    while(1) {
        // Delay a specified period of time or wait for push-button to be pressed
        wait(0.1);
 
        // Update state/counter
        state = (state + 1) % 6;

        // Reset all outputs 
        led1 = led2 = led3 = led4 = led5 = led6 = 1;
        
        // Set only the active output
        switch(state) {
            case 0:
                led1 = 0;
                break;
            case 1:
                led2 = 0;
                break;
            case 2:
                led3 = 0;
                break;
            case 3:
                led4 = 0;
                break;
            case 4:
                led5 = 0;
                break;
            case 5:
                led6 = 0;
                break;
        }
    }
}

static void experiment1_alt2()
{
    int state = 0;

    // Set LED start values
    led1 = led2 = led3 = led4 = led5 = led6 = 1;
    
    // Enable buttons
    button1.mode(PullUp);
 
    // Enter forever loop
    while(1) {
        // Delay a specified period of time or wait for push-button to be pressed
        wait(0.1);
 
        // Update state/counter
        state = (state + 1) % 6;

        //Set and reset the outputs
        switch(state) {
            case 0:
                led2 = led3 = led4 = led5 = led6 = 1;
                led1 = 0;
                break;
            case 1:
                led1 = led3 = led4 = led5 = led6 = 1;
                led2 = 0;
                break;
            case 2:
                led1 = led2 = led4 = led5 = led6 = 1;
                led3 = 0;
                break;
            case 3:
                led1 = led2 = led3 = led5 = led6 = 1;
                led4 = 0;
                break;
            case 4:
                led1 = led2 = led3 = led4 = led6 = 1;
                led5 = 0;
                break;
            case 5:
                led1 = led2 = led3 = led4 = led5 = 1;
                led6 = 0;
                break;
        }
    }
}

static void experiment1_alt3()
{
    int state = 0;

    // Set LED start values
    led1 = led2 = led3 = led4 = led5 = led6 = 1;
    
    // Enable buttons
    button1.mode(PullUp);
 
    // Enter forever loop
    while(1) {
        // Wait for push-button to be pressed
        while(button1) {
        }
        while(!button1) {
        }
 
        // Update state/counter
        state = (state + 1) % 6;

        //Set and reset the outputs
        switch(state) {
            case 0:
                led2 = led3 = led4 = led5 = led6 = 1;
                led1 = 0;
                break;
            case 1:
                led1 = led3 = led4 = led5 = led6 = 1;
                led2 = 0;
                break;
            case 2:
                led1 = led2 = led4 = led5 = led6 = 1;
                led3 = 0;
                break;
            case 3:
                led1 = led2 = led3 = led5 = led6 = 1;
                led4 = 0;
                break;
            case 4:
                led1 = led2 = led3 = led4 = led6 = 1;
                led5 = 0;
                break;
            case 5:
                led1 = led2 = led3 = led4 = led5 = 1;
                led6 = 0;
                break;
        }
    }
}

static void experiment1_alt4()
{
    int state = 0;
    int waited = 0;

    // Set LED start values
    led1 = led2 = led3 = led4 = led5 = led6 = 1;
    
    // Enable buttons
    button1.mode(PullUp);
 
    // Enter forever loop
    while(1) {
        // Delay a specified period of time or wait for push-button to be pressed
        if (button1) {
            // button is not pressed so we wait 10ms more
            wait_ms(10);
            waited += 10;
            if (waited < 5000) {
                // have not waited 5 seconds yet
                continue;
            }
        } else {
            // wait for button to be released
            while(!button1) {
            }
        }
        
        // ended up here either because the user pressed the button or 5 seconds have passed
        waited = 0;
 
        // Update state/counter
        state = (state + 1) % 6;

        //Set and reset the outputs
        switch(state) {
            case 0:
                led2 = led3 = led4 = led5 = led6 = 1;
                led1 = 0;
                break;
            case 1:
                led1 = led3 = led4 = led5 = led6 = 1;
                led2 = 0;
                break;
            case 2:
                led1 = led2 = led4 = led5 = led6 = 1;
                led3 = 0;
                break;
            case 3:
                led1 = led2 = led3 = led5 = led6 = 1;
                led4 = 0;
                break;
            case 4:
                led1 = led2 = led3 = led4 = led6 = 1;
                led5 = 0;
                break;
            case 5:
                led1 = led2 = led3 = led4 = led5 = 1;
                led6 = 0;
                break;
        }
    }
}

static void experiment2()
{
    bool started = true;
    bool flowdown = true;
    int speed = 1;
    int state = 0;
    int waited = 0;

    // Set LED start values
    led1 = led2 = led3 = led4 = led5 = led6 = 1;
    
    // Enable buttons
    button1.mode(PullUp); // increase speed
    button2.mode(PullUp); // direction control
    button3.mode(PullUp); // start/stop
 
    // Enter forever loop
    while(1) {
        wait_ms(10);
        waited += 10;
        
        // Detect if the sequence should be started/stopped
        if (!button3) {
            while(!button3) {
            }
            if (started) {
                started = false;
                continue;
            } else {
                started = true;
                waited = 0;
            }
        }
        if (!started) {
            continue;
        }
        
        // Detect direction change (and wait for user to let go of button)
        if (!button2) {
            flowdown = !flowdown;
            while(!button2) {
            }
        }
        
        // Detect speed change (increase one step per button press and reset
        // when max is reached)
        if (!button1) {
            speed = (speed + 4) % 5;
            while(!button1) {
            }
        }
        
        // If we have not waited enough (based on current speed) then wait some more
        if (waited < (500 * speed)) {
            continue;
        }
        waited = 0;
         
        // Update state/counter based on direction
        if (flowdown) {
            state = (state + 1) % 6;
        } else {
            state = (state + 5) % 6;
        }

        //Set and reset the outputs
        switch(state) {
            case 0:
                led2 = led3 = led4 = led5 = led6 = 1;
                led1 = 0;
                break;
            case 1:
                led1 = led3 = led4 = led5 = led6 = 1;
                led2 = 0;
                break;
            case 2:
                led1 = led2 = led4 = led5 = led6 = 1;
                led3 = 0;
                break;
            case 3:
                led1 = led2 = led3 = led5 = led6 = 1;
                led4 = 0;
                break;
            case 4:
                led1 = led2 = led3 = led4 = led6 = 1;
                led5 = 0;
                break;
            case 5:
                led1 = led2 = led3 = led4 = led5 = 1;
                led6 = 0;
                break;
        }
    }
}

int main()
{
    //experiment1_alt1(); // one way of controlling the LEDs
    //experiment1_alt2(); // another way of controlling the LEDs
    //experiment1_alt3(); // wait for button press
    //experiment1_alt4(); // wait for button press or timeout
    experiment2();
}