#include "mbed.h"

InterruptIn event(D0);

DigitalOut greenLED(LED_GREEN);
DigitalOut redLED(LED_RED);
DigitalOut blueLED(LED_BLUE);

DigitalIn button(D0);

Ticker timer;
Ticker timerGreen;
Ticker timerBlue;


void trigger_alt1() {
     // add code to blink the LED
     redLED = 0;
}

static void experiment1_alt1()
{
    redLED = greenLED = blueLED = 1;  // Turn LEDs off
    
    // Register the handler for falling edges
    event.mode(PullUp);
    event.fall(&trigger_alt1);
    while(1) {
        //redLED = 1;
    }
}

void trigger_alt2() {
    greenLED = 0;
    while (!button) {
    }
    greenLED = 1;
}
 
static void experiment1_alt2()
{
    // Register the handler for falling edges
    event.mode(PullUp);
    event.fall(&trigger_alt2);
 
    // Turn LEDs off
    greenLED = 1;
    redLED = 1;
    blueLED = 1;
    
    while(1) {
        redLED = !redLED;
        wait(0.1);
    }
}


static void ticker_event() 
{
    static bool on = false;
    on = !on;
    
    // add code to blink the LED
    redLED = (on ? 0 : 1);
}
 
static void experiment2_alt1()
{
    redLED = greenLED = blueLED = 1;  // Turn LEDs off
    
    // Request the timer function to be called every 5 seconds
    timer.attach(&ticker_event, 5);
    while(1) {
        ;
    }
}

static void ticker_event_green() 
{
    static bool on = false;
    on = !on;
    
    // add code to blink the LED
    greenLED = (on ? 0 : 1);
}
static void ticker_event_blue() 
{
    static bool on = true;
    on = !on;
    
    // add code to blink the LED
    blueLED = (on ? 0 : 1);
}
static void experiment2_alt2()
{
    redLED = greenLED = blueLED = 1;  // Turn LEDs off
    
    // Create one timer for each color. If the same timer is used then only
    // the last call to attach will work (previous calls are overwritten)
    timer.attach(&ticker_event, 0.4);
    timerGreen.attach(&ticker_event_green, 0.2);
    timerBlue.attach(&ticker_event_blue, 0.1);
    while(1) {
        ;
    }
}


int main()
{
    //experiment1_alt1(); //simple trigger
    //experiment1_alt2(); //trigger which takes time to complete
    //experiment2_alt1(); //blinks the RED led every 5 seconds
    experiment2_alt2(); //blinks all three components of the RGB LED
}