#include "mbed.h"
#include "PCA9672.h"
 
PCA9672 ioxp(P0_10, P0_11); //I2C connected to PCA9672 in LPC800-MAX
 
Serial pc(USBTX, USBRX); // tx, rx

static void experiment1_alt1()
{
    ioxp.frequency(100000);
    ioxp.direction(0x80); // mark the push-button pin as input and the rest as outputs
 
    while (1) {
        uint8_t val = ioxp.read();
        pc.printf("Reading 0x%02x - bit 7 is %d\n", val, val>>7);
        if (val & 0x80)
        {
            ioxp.write(0x10);
        }
        else
        {
            ioxp.write(0x20);
        }
        wait(.50);
    }
}

static void experiment1_alt2()
{
    ioxp.frequency(100000);
    ioxp.direction(0x80 | 0x20); // mark the push-button pins (on breadboard and onboard) as inputs
 
    while (1) {
        uint8_t val = ioxp.read();
        pc.printf("Reading 0x%02x - bit 7 is %d, bit 5 is %d\n", val, (val>>7)&1, (val>>5)&1);
        if (((val & 0xa0)==0xa0) || ((val & 0xa0)==0x00))
        {
            // both or neither buttons are pressed
            ioxp.write(0x10);
        }
        else
        {
            // exactly one of the buttons are pressed
            ioxp.write(0x00);
        }
        wait(.50);
    }
}

int main()
{
    //experiment1_alt1(); //onboard button controls yellow (pressed) and green (released) LEDs
    experiment1_alt2(); //two buttons. Yellow LED lit with exactly one is pressed
}