#ifndef PCA9672_H
#define PCA9672_H
 
#include "mbed.h"
 
//  PCA9672 IIC slave address
#define  PCA9672_ADDR 0x46
 
 
//!Library for the PCA9672 I/O expander.
/*!
The PCA9672 is an I2C I/O expander. It has 8 I/O pins.
*/
class PCA9672
{
public:
  /*!
  Connect PCA9672 to I2C port pins sda and scl.
  */
  PCA9672(PinName sda, PinName scl);
  
  /*!
  Set the frequency of the I2C interface.
  */
  void frequency(int hz);
 
  /*!
  Setup pin direction (bit = 1 for inputs, 0 for outputs)
  */
  void direction(uint8_t inputs);
  
  /*!
  Write the value to the IO Expander (pins XP0-XP7 output)
  */
  void write(char value);
  
  /*!
  Read the value of the IO Expander (pins XP0-XP7 input)
  */
  int read(void);
    
  /*!
  Destroys instance.
  */ 
  ~PCA9672();
  
private:
  
  I2C _i2c;
  uint8_t _pins;
 
};
 
#endif