#include "PCA9672.h"
 
PCA9672::PCA9672(PinName sda, PinName scl) : _i2c(sda, scl)
{
    // Software Reset
    _i2c.start();
    while(_i2c.write(0x00) !=1);
    while(_i2c.write(0x06) !=1);
    _i2c.stop();
 
    /* Software reset is not required. But, gives an 
       indication if the selected I2C bus frequency works */
}
 
void PCA9672::frequency(int hz)
{
    _i2c.frequency(hz);
}

void PCA9672::direction(uint8_t inputs)
{
    _pins = inputs & 0xff;
}
 
void PCA9672::write(char value)
{
    if (_pins > 0)
    {
        _i2c.start();
        _i2c.write(PCA9672_ADDR);
        _i2c.write(value | _pins); // all input pins must have a logic 1 as value
        _i2c.stop();
    }
}
 
int PCA9672::read(void)
{
    _i2c.start();
    _i2c.write(PCA9672_ADDR | 1);
    uint8_t val = _i2c.read(0); // expect NACK
    _i2c.stop();
    return val;
}
 
PCA9672::~PCA9672()
{
 
}