#include "mbed.h"
#include "MTK3339.h"
 
static int waitData = 0;
static MTK3339 gps(P0_4, P0_0);
 
 
static void dataAvailable() {
    waitData |= gps.getAvailableDataType();
}
 
int main(void) {
   
    gps.start(&dataAvailable, (MTK3339::NmeaGga|MTK3339::NmeaVtg));
 
    while(1) {
        while(waitData == 0);
        
        if ((waitData & MTK3339::NmeaGga) != 0) {
            waitData &= ~(MTK3339::NmeaGga);
            printf("gpa: fix=%d, sats=%d, alt=%f, lat=%f, lon=%f\n", 
                gps.gga.fix, gps.gga.satellites, gps.gga.altitude, 
                gps.getLatitudeAsDegrees(), gps.getLongitudeAsDegrees());            
        }
        if ((waitData & MTK3339::NmeaVtg) != 0) {
            waitData &= ~(MTK3339::NmeaVtg);
            printf("vtg: course=%f, speed=%f km/h, mode=%c\n", 
                gps.vtg.course, gps.vtg.speedKmHour, gps.vtg.mode);            
        }   
        
        waitData &= (MTK3339::NmeaGga|MTK3339::NmeaVtg);
    }
}
