#include "mbed.h"

DigitalIn button1(D0);
DigitalIn button2(D1);
DigitalOut buzzer(D3);
DigitalOut led(LED_RED);

static void experiment1()
{
    led = 1;  // Turn LED off
    
    button1.mode(PullUp); // Enable button
 
    // Enter forever loop
    while(1) {
        // Check if push-button is pressed (input is low)
        if (button1.read() == 0) {
            led = 0; // Button pressed so turn on LED
        } else {
            led = 1; // Button not pressed so turn off LED
        }
    }
}

static void experiment2()
{
    led = 1;  // Turn LED off
    
    button1.mode(PullUp); // Enable button
    button2.mode(PullUp); // Enable button
 
    // Enter forever loop
    while(1) {
        int state1 = button1.read();
        int state2 = button2.read();
        
        // Check if push-button is pressed (input is low)
        if (state1 == 0) {
            if (state2 == 0) {
                // Both pressed so turn off LED/buzzer
                led = 1;
                buzzer = 1;
            } else {
                // Only one pressed so turn on LED/buzzer
                led = 0;
                buzzer = 0;
            }
        } else {
            if (state2 == 0) {
                // Only one pressed so turn on LED/buzzer
                led = 0;
                buzzer = 0;
            } else {
                // Both pressed so turn off LED/buzzer
                led = 1;
                buzzer = 1;
            }
        }
    }
}


static void experiment3()
{
    bool ledOn = false;

    led = 1;  // Turn LED off
    
    button1.mode(PullUp); // Enable button
 
    // Enter forever loop
    while(1) {
        
        // Check if push-button is pressed (input is low)
        if (!button1) {
            // Toggle LED
            ledOn = !ledOn;
            if (ledOn) {
                led = 0;
            } else {
                led = 1;
            }
            
            // Wait until push-button is released
            while (!button1) {
            }
        }
    }
}

static void experiment4()
{
    bool ledOn = false;

    led = 1;  // Turn LED off
    
    button1.mode(PullUp); // Enable button
 
    // Enter forever loop
    while(1) {
        // Delay a specified period of time (the sample period)
        wait_ms(10);
        
        // Check if push-button is pressed (input is low)
        if (!button1) {
            // Toggle LED
            ledOn = !ledOn;
            if (ledOn) {
                led = 0;
            } else {
                led = 1;
            }
            
            // Wait until push-button is released
            while (!button1) {
            }
        }
    }
}

int main()
{
    //experiment1();
    //experiment2();
    //experiment3();
    experiment4();
}