#include "mbed.h"
#include "TextLCD.h"

Serial pc(USBTX, USBRX); // tx, rx

TextLCD lcd(D0, D3, D10, D11, D12, D13, TextLCD::LCD16x2); // rs, e, d4-d7

static void experiment1_alt1()
{
    // Example code from https://mbed.org/cookbook/Text-LCD-Enhanced
    pc.printf("LCD Test. Columns=%d, Rows=%d\n\r", lcd.columns(), lcd.rows());

    for (int row=0; row<lcd.rows(); row++) {
        int col=0;

        pc.printf("MemAddr(Col=%d, Row=%d)=0x%02X\n\r", col, row, lcd.getAddress(col, row));
//      lcd.putc('-');
        lcd.putc('0' + row);

        for (col=1; col<lcd.columns()-1; col++) {
            lcd.putc('*');
        }

        pc.printf("MemAddr(Col=%d, Row=%d)=0x%02X\n\r", col, row, lcd.getAddress(col, row));
        lcd.putc('+');

    }

    // Show cursor as blinking character
    lcd.setCursor(TextLCD::CurOff_BlkOn);

    // Set and show user defined characters. A maximum of 8 UDCs are supported by the HD44780.
    // They are defined by a 5x7 bitpattern.
    lcd.setUDC(0, (char *) udc_0);  // Show |>
    lcd.putc(0);
    lcd.setUDC(1, (char *) udc_1);  // Show <|
    lcd.putc(1);
    lcd.setUDC(2, (char *) udc_2);
    lcd.putc(2);
    lcd.setUDC(3, (char *) udc_3);
    lcd.putc(3);
    lcd.setUDC(4, (char *) udc_4);
    lcd.putc(4);
    lcd.setUDC(5, (char *) udc_5);
    lcd.putc(5);
    lcd.setUDC(6, (char *) udc_6);
    lcd.putc(6);
    lcd.setUDC(7, (char *) udc_7);
    lcd.putc(7);

    while(1)
        ;
}

static void experiment1_alt2()
{
    pc.printf("LCD Test. Columns=%d, Rows=%d\n\r", lcd.columns(), lcd.rows());

    // Clear screen
    lcd.cls();      
    
    lcd.printf("Hello\nWorld!");
    wait(3);

    // Example using putc() which automatically moves the cursor
    lcd.cls();
    for (char c = '0'; c <= 'Z' ; c++)
    {
        lcd.putc(c);
        wait(0.3);
    }

    while(1)
        ;
}


int main()
{
    //experiment1_alt1(); // The sample application that comes with the library
    experiment1_alt2(); // Hello World!
}