#include "mbed.h"

DigitalIn button(D0);

DigitalOut segA(D4);
DigitalOut segB(D7);
DigitalOut segC(D8);
DigitalOut segD(D10);
DigitalOut segE(D11);
DigitalOut segF(D12);
DigitalOut segG(D13);
DigitalOut segDP(D9);

static void show(int val) {
    // turn off all segments
    segA = segB = segC = segD = segE = segF = segG = 1;
    
    // turn on segments depending on what to show
    switch (val) {
        case 0: segA = segB = segC = segD = segE = segF =        0; break;
        case 1:        segB = segC =                             0; break;
        case 2: segA = segB =        segD = segE =        segG = 0; break;
        case 3: segA = segB = segC = segD =               segG = 0; break;
        case 4:        segB = segC =               segF = segG = 0; break;
        case 5: segA =        segC = segD =        segF = segG = 0; break;
        case 6: segA =        segC = segD = segE = segF = segG = 0; break;
        case 7: segA = segB = segC =                             0; break;
        case 8: segA = segB = segC = segD = segE = segF = segG = 0; break;
        case 9: segA = segB = segC = segD =        segF = segG = 0; break;
        
        case 'A': segA = 0; break;
        case 'B': segB = 0; break;
        case 'C': segC = 0; break;
        case 'D': segD = 0; break;
        case 'E': segE = 0; break;
        case 'F': segF = 0; break;
        case 'G': segG = 0; break;
    }
}

static void experiment2_alt1()
{
    // Enter forever loop
    while(1) {
        for (int i = 0; i < 10; i++) {
            // Delay a specified period of time or wait for push-button to be pressed
            wait(0.3);
            
            show(i);
        }
    }
}

static void experiment2_alt2()
{
    // Enable button
    button.mode(PullUp);
 
    // Enter forever loop
    while(1) {
        for (int i = 0; i < 10; i++) {
            // Delay a specified period of time or wait for push-button to be pressed
            while(button);
            while(!button);
            
            show(i);
        }
    }
}

static void experiment2_alt3()
{
    // Enter forever loop
    while(1) {
        for (int i = 'A'; i < 'G'; i++) {
            // Delay a specified period of time or wait for push-button to be pressed
            wait(0.3);
            
            show(i);
        }
    }
}


int main()
{
    // turn off all segments
    segA = segB = segC = segD = segE = segF = segG = segDP = 1;
    
    //experiment2_alt1(); // Automatic counting
    //experiment2_alt2(); // Push button advances counting
    experiment2_alt3(); // Automatic running one
}