#include "mbed.h"

DigitalOut ssel(D10);
DigitalOut mosi(D11);
DigitalOut sclk(D13);

#define SEG_A   0x80
#define SEG_B   0x40
#define SEG_C   0x20
#define SEG_D   0x10
#define SEG_E   0x08
#define SEG_F   0x04
#define SEG_G   0x02
#define SEG_DP  0x01

const uint8_t segments[16] = {
    SEG_A | SEG_B | SEG_C | SEG_D | SEG_E | SEG_F        ,  //0 = A,B,C,D,E,F
            SEG_B | SEG_C                                ,  //1 = B,C
    SEG_A | SEG_B |         SEG_D | SEG_E |         SEG_G,  //2 = A,B,D,E,G
    SEG_A | SEG_B | SEG_C | SEG_D |                 SEG_G,  //3 = A,B,C,D,G
            SEG_B | SEG_C |                 SEG_F | SEG_G,  //4 = B,C,F,G
    SEG_A |         SEG_C | SEG_D |         SEG_F | SEG_G,  //5 = A,C,D,F,G
    SEG_A |         SEG_C | SEG_D | SEG_E | SEG_F | SEG_G,  //6 = A,C,D,E,F,G
    SEG_A | SEG_B | SEG_C                                ,  //7 = A,B,C
    SEG_A | SEG_B | SEG_C | SEG_D | SEG_E | SEG_F | SEG_G,  //8 = A,B,C,D,E,F,G
    SEG_A | SEG_B | SEG_C | SEG_D |         SEG_F | SEG_G,  //9 = A,B,C,D,F,G
    SEG_A | SEG_B | SEG_C |         SEG_E | SEG_F | SEG_G,  //A = A,B,C,E,F,G
                    SEG_C | SEG_D | SEG_E | SEG_F | SEG_G,  //B = C,D,E,F,G
                            SEG_D | SEG_E |         SEG_G,  //C = D,E,G
            SEG_B | SEG_C | SEG_D | SEG_E |         SEG_G,  //D = B,C,D,E,G
    SEG_A |                 SEG_D | SEG_E | SEG_F | SEG_G,  //E = A,D,E,F,G
    SEG_A |                         SEG_E | SEG_F | SEG_G}; //F = A,E,F,G

static void updateShiftReg(uint8_t segments)
{
    uint8_t bitCnt;

    //Pull SCK and MOSI low, pull SSEL low
    ssel = 0;
    mosi = 0;
    sclk = 0;
    
    //wait 1us
    wait_us(1);
    
    //Loop through all eight bits
    for (bitCnt = 0; bitCnt < 8; bitCnt++)
    {
        //output MOSI value (depends on bit 7 of "segments")
        if (segments & 0x80) {
            mosi = 1;
        } else {
            mosi = 0;
        }
        
        //wait 1us
        wait_us(1);

        //pull SCK high
        sclk = 1;
        
        //wait 1us
        wait_us(1);
        
        //pull SCK low
        sclk = 0;
        
        //shift "segments"
        segments = segments << 1;
    }

    //Pull SSEL high
    ssel = 1;
}

static void experiment3()
{
    while(1) {
        for (int i = 0; i < 16; i++) {
            updateShiftReg(~segments[i]);
            wait(0.4);
        }
    }
}

int main()
{
    experiment3();
}