#ifndef PCF8591_H
#define PCF8591_H

/**
 * Interface to the PCF8591 chip (http://www.nxp.com/documents/data_sheet/PCF8591.pdf)
 * which has four 8-bit analog inputs and one 8-bit analog output.
 *
 * @code
 * #include "mbed.h"
 *
 * PCF8591 adc;
 *
 * int main(void) {
 *
 *    while(1) {
 *       // read analog value
 *       int val = adc.read(PCF8591::A0);
 *
 *       // do something with value...
 *    }
 * }
 * @endcode
 */
class PCF8591 {
public:

    enum AnalogIn {
        A0,
        A1,
        A2,
        A3
    };

    
    /** Create an interface to the PCF8591 chip
     *
     *
     *  @param sda the I2C SDA pin
     *  @param scl the I2C SCL pin
     *  @param i2cAddr the upper 7 bits of the chip's address
     */
    PCF8591(PinName sda = P0_10, PinName scl = P0_11, int i2cAddr = 0x9E);
    
    /** Reads one value for the specified analog port
     *
     *  @param port the analog in to read (A0..A3)
     *
     *  @returns
     *       the value on success (0..255)
     *       -1 on failure
     */
    int read(AnalogIn port);

private:
    I2C m_i2c;
    int m_addr;
};

#endif

