#include "mbed.h"
#include "PCF8591.h"

PCF8591::PCF8591(PinName sda, PinName scl, int i2cAddr) : m_i2c(sda, scl)
{
    m_i2c.frequency(100000);
    m_addr = i2cAddr;
}
    
int PCF8591::read(AnalogIn port)
{
    char cmd = (port & 0x3); // read from selected port
    char data[2];
    
    // select the port
    m_i2c.start();
    m_i2c.write(m_addr);
    m_i2c.write(cmd);
    m_i2c.stop();
    
    // get the sample
    m_i2c.start();
    m_i2c.write(m_addr | 1);
    data[0] = m_i2c.read(1); // expect ACK
    data[1] = m_i2c.read(0); // expect NACK
    m_i2c.stop();
    
    // data[0] is a dummy byte so ignore it
    // data[1] is the new value
    return data[1];
}

