// Simple USBHost MSD(USB Flash drive) for EA LPC4088 QSB test program
#include "USBHostMSD.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
#define LED_OFF 0
#define LED_ON  1

int main() {
    USBHostMSD msd("usb");
    if (!msd.connect()) {
        error("USB Flash drive not found.\n");
    }    
    FILE* fp = fopen("/usb/test1.txt", "a");
    if (fp) {
        fprintf(fp, "Hello from EA LPC4088 QSB\n");
        for(int i = 0; i < 21; i++) {
            fprintf(fp, " %d", i);
            led2 = !led2;
        }
        fprintf(fp, "\n");
        fclose(fp);
    }
    fp = fopen("/usb/test1.txt", "r");
    if (fp) {
        int n = 0;
        while(1) {
            int c = fgetc(fp);
            if (c == EOF) {
                break;
            }
            printf("%c", c);
            n++;
            led1 = !led1;
        }
        fclose(fp);
        printf("%d bytes\n", n);
    }
    led2 = LED_OFF;
    while(1) {
        led1 = !led1;
        wait_ms(200);
    }
}
