#include "mbed.h"
#include "HTTPClient.h"

//------------------------------------------------------------------------------------
// You need to configure these cellular modem / SIM parameters.
// These parameters are ignored for LISA-C200 variants and can be left NULL.
//------------------------------------------------------------------------------------
#include "MDM.h"
//! Set your secret SIM pin here (e.g. "1234"). Check your SIM manual.
#define SIMPIN      NULL
/*! The APN of your network operator SIM, sometimes it is "internet" check your 
    contract with the network operator. You can also try to look-up your settings in 
    google: https://www.google.de/search?q=APN+list */
#define APN         "online.telia.se"
//! Set the user name for your APN, or NULL if not needed
#define USERNAME    NULL
//! Set the password for your APN, or NULL if not needed
#define PASSWORD    NULL 
//------------------------------------------------------------------------------------

char str[512];

int main() 
{
    // turn on the supplies of the Modem
    MDMSerial mdm;
    //mdm.setDebug(4); // enable this for debugging issues 
    if (!mdm.connect(SIMPIN, APN,USERNAME,PASSWORD))
        return -1;
    HTTPClient http;
  
    //GET data
    printf("\nTrying to fetch page...\n");
    int ret = http.get("http://mbed.org/media/uploads/donatien/hello.txt", str, 128);
    if (!ret)
    {
      printf("Page fetched successfully - read %d characters\n", strlen(str));
      printf("Result: %s\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    
    //POST data
    HTTPMap map;
    HTTPText inText(str, 512);
    map.put("Hello", "World");
    map.put("test", "1234");
    printf("\nTrying to post data...\n");
    ret = http.post("http://httpbin.org/post", map, &inText);
    if (!ret)
    {
      printf("Executed POST successfully - read %d characters\n", strlen(str));
      printf("Result: %s\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    
    //PUT data
    strcpy(str, "This is a PUT test!");
    HTTPText outText(str);
    //HTTPText inText(str, 512);
    printf("\nTrying to put resource...\n");
    ret = http.put("http://httpbin.org/put", outText, &inText);
    if (!ret)
    {
      printf("Executed PUT successfully - read %d characters\n", strlen(str));
      printf("Result: %s\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    
    //DELETE data
    //HTTPText inText(str, 512);
    printf("\nTrying to delete resource...\n");
    ret = http.del("http://httpbin.org/delete", &inText);
    if (!ret)
    {
      printf("Executed DELETE successfully - read %d characters\n", strlen(str));
      printf("Result: %s\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }

    mdm.disconnect();
    mdm.powerOff();

    while(true);
}
