/******************************************************************************
 * Includes
 *****************************************************************************/
#include "mbed.h"
#include "TextLCD.h"

/******************************************************************************
 * Typedefs and defines
 *****************************************************************************/

/******************************************************************************
 * Local variables
 *****************************************************************************/

DigitalOut myled(LED1);

SPI spi_lcd(p5, p6, p7); // MOSI, MISO, SCLK

/******************************************************************************
 * Local functions
 *****************************************************************************/

/*
 Hardware Setup:
 
 - Jumpers JP1..JP6 should be in position 1-2
 - Jumpers in J14 should NOT be inserted
 - Jumper J7 should be inserted
 - Display in connector J10. Display should be over the base board - not outside
*/

int main() {
    TextLCD_SPI lcd(&spi_lcd, p30, TextLCD::LCD16x2); // SPI bus, CS pin, LCD Type ok
    
    lcd.cls();
    lcd.locate(0, 0);
    lcd.putc('E');
    lcd.putc('m');
    lcd.putc('b');
    lcd.putc('e');
    lcd.putc('d');
    lcd.putc('d');
    lcd.putc('e');
    lcd.putc('d');
    lcd.putc(' ');
    lcd.putc('A');
    lcd.putc('r');
    lcd.putc('t');
    lcd.putc('i');
    lcd.putc('s');
    lcd.putc('t');
    lcd.putc('s');
    lcd.putc('!');
    lcd.setCursor(TextLCD::CurOff_BlkOn);
    
    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
