/******************************************************************************
 * Includes
 *****************************************************************************/
#include "mbed.h"

#include "TestRGBLed.h"
#include "TestFileSystemMCI.h"
#include "TestFileSystemSPI.h"
#include "TestAcc.h"
#include "TestTemperature.h"
#include "TestTrimpot.h"
#include "TestJoystick.h"
#include "TestAudio.h"
#include "TestShiftreg.h"
#include "TestDisplay.h"

/******************************************************************************
 * Typedefs and defines
 *****************************************************************************/


/******************************************************************************
 * Local variables
 *****************************************************************************/

DigitalOut myled(LED1);

/******************************************************************************
 * Local functions
 *****************************************************************************/


static void setupSerial(int baudrate)
{
    // This works because both the default serial (used by printf) and the s instance
    // (used by s.printf) would use the same underlying UART code so setting the baudrate
    // in one affects the other.
    Serial s(USBTX, USBRX);
    s.baud(baudrate);
}

int main() {
    setupSerial(115200);
    printf("\n"
           "---\n"
           "Production Test Program: LPC4088 Experiment Base Board\n"
           "Build Date: " __DATE__ " at " __TIME__ "\n"
           "\n");
    
    // run all tests
    int failed = 0;
    
    TestRGBLed rgb;
    TestFileSystemMCI mcifs;
    TestAcc acc;
//    TestFileSystemSPI spifs;
    TestTemperature temp;
    TestTrimpot trim;
    TestJoystick joy;
    TestShiftreg shift;
    TestDisplay display;
    TestAudio audio;
    
    /* NOTE: Audio must be initialized AFTER the display as they both reference the same pins
             (P0_4, P0_5, P0_6, P0_7, P0_8, P0_9). However the display only uses those pins
             for 24-bit color depth and we only use 16-bit in this demo. */
    
    //startup flash behaviour
    rgb.showStartupPattern();
    
    if (!mcifs.runTest()) {
        failed++;
    }

//    if (!spifs.runTest()) {
//        failed++;
//    }
    
    if (!acc.runTest()) {
        failed++;
    }

    if (!temp.runTest()) {
        failed++;
    }
    
    if (!trim.runTest()) {
        failed++;
    }

    if (!joy.runTest()) {
        failed++;
    }
    
    if (!rgb.runTest()) {
        failed++;
    }

    if (!audio.runTest()) {
        failed++;
    }

    if (!display.runTest()) {
        failed++;
    }
    
    if (failed == 0) {
        printf("\n\n---\nTest PASSED\n\n");
        printf("NOTE: The display as well as the shift register LEDs\n"
               "      must be manually checked as well\n\n");
    } else {
        printf("\n\n---\nTest FAILED  (%d failed parts)\n\n", failed);
    }
    rgb.showStatus(failed == 0);
    display.showStatus(failed == 0);

    while(1) {
        shift.runTest();
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
