/*
 *  Copyright 2013 Embedded Artists AB
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/******************************************************************************
 * Includes
 *****************************************************************************/

#include "mbed.h"
#include "TestTemperature.h"
#include "LM75B.h"

/******************************************************************************
 * Defines and typedefs
 *****************************************************************************/

#define MIN_TEMP  (15.0f)
#define MAX_TEMP  (45.0f)

/******************************************************************************
 * Public Functions
 *****************************************************************************/

/*
   Prerequisites:
 
   - For this test to work jumpers JP8 and JP9 on the LPC4088 Experiment Base Board
     must both be in positions 1-2
*/

bool TestTemperature::runTest() {
    //Create an LM75B object at 0x92/0x93 (ADDRESS_1)
    LM75B sensor(P0_27, P0_28, LM75B::ADDRESS_1);

    printf("Testing LM75 temperature sensor...\n");

    // Test waits up to 5 seconds, sampling the temperature twice per second,
    // for the sensor to produce a value in the MIN_TEMP to MAX_TEMP range.
    
    if (sensor.open()) {
        printf("LM75 Device detected!\n");
 
        int i = 10;
        while (i--) {
            float f = (float)sensor;

            printf("Temp = %.3f\n", f);
 
            if ((f >= MIN_TEMP) && (f <= MAX_TEMP)) {
                printf("Temp in %.3f..%.3f range - test passed\n", MIN_TEMP, MAX_TEMP);
                return true;
            }
            
            //Sleep for 0.5 seconds
            wait(0.5);
        }
        if (i == 0) {
            printf("LM75 No temp in range %.3f..%.3f!\n", MIN_TEMP, MAX_TEMP);
        }
    } else {
        printf("LM75 Device not detected!\n");
    }  
    return false;
}


