/*
 *  Copyright 2013 Embedded Artists AB
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/******************************************************************************
 * Includes
 *****************************************************************************/

#include "mbed.h"
#include "TestJoystick.h"

/******************************************************************************
 * Defines and typedefs
 *****************************************************************************/

#define TIMEOUT  (100)

/******************************************************************************
 * Public Functions
 *****************************************************************************/

bool TestJoystick::runTest() {
    DigitalIn up(p32);
    DigitalIn down(p38);
    DigitalIn left(p39);
    DigitalIn right(p37);
    DigitalIn center(p31);

    printf("Reading joystick for %d seconds...\n", TIMEOUT/10);  
    printf("Move it in all directions and click it!\n");
    uint16_t mask = 0;

    for (int i = 0; i < TIMEOUT; i++) {
        bool line = false;
        if (up.read() == 0) { printf("UP ");        line = true; mask |= 0x01; }
        if (down.read() == 0) { printf("DOWN ");    line = true; mask |= 0x02; }
        if (left.read() == 0) { printf("LEFT ");    line = true; mask |= 0x04; }
        if (right.read() == 0) { printf("RIGHT ");  line = true; mask |= 0x08; }
        if (center.read() == 0) { printf("CENTER ");line = true; mask |= 0x10; }
        if (line) {
            printf("\n");
        }
        if (mask == 0x1F) {
            printf("All directions tested. Done!\n");
            return true;
        }
        wait(0.1);
        if (i%10 == 0) {
            printf("%ds\n", (TIMEOUT-i)/10);
        }
    }
    printf("Failed to detect all joystick directions\n");
    return false;
}


