/*
 *  Copyright 2013 Embedded Artists AB
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/******************************************************************************
 * Includes
 *****************************************************************************/

#include "mbed.h"
#include "TestFileSystemMCI.h"
#include "MCIFileSystem.h"

/******************************************************************************
 * Defines and typedefs
 *****************************************************************************/


/******************************************************************************
 * Public Functions
 *****************************************************************************/

/*
   Prerequisites:
 
   - For this test to work jumpers JP1..JP6 on the LPC4088 Experiment Base Board
     must all be in positions 1-2, that is closest to the center of the board.
 
   - The uSD card must be formatted as FAT or FAT32, NTFS will not work.
 
   - This test expects a file with the name message.txt to exist in the
     root folder on the uSD card. The file must be at least 10 bytes in
     size and the first bytes must be eatest2014
*/

bool TestFileSystemMCI::runTest() {
    printf("Testing MCI file system. If this test takes a lot of time make sure that\n"
           "there is a uSD card inserted and that the jumpers are inserted according\n"
           "to the instructions!\n");
    
    // The LPC4088 Experiment Base Board does not have the CardDetect signal
    // available so it must be set to NC here to work.
    MCIFileSystem mcifs("mci", NC);

    FILE* fp = fopen("/mci/message.txt", "r");
    if (fp != NULL) {
        char buf[20];
        int num = fread(buf, 1, sizeof(buf), fp);
        if (num >= 10) {
            buf[10] = '\0';
            if (strcmp(buf, "eatest2014") == 0) {
                printf("MCI SD Card works!\n");
                fclose(fp);
                return true;
            }
            printf("Invalid data read from /mci/message.txt\n");
        }
        printf("Failed to read >= 10 bytes from /mci/message.txt\n");
    }
    printf("Failed to open /mci/message.txt\n");
    return false;
}


