/*
 *  Copyright 2013 Embedded Artists AB
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

#ifndef TESTAUDIO_H
#define TESTAUDIO_H

#include "WM8731.h"
#include "I2S.h"

#define ECHOLENGTH 12000


/**
 * Test the WM8731 audio codec and the audio connectors on 
 * the LPC4088 Experiment Base Board
 */
class TestAudio {
public:

    /**
     * Create an interface to the audio codec
     */
    TestAudio();

    /**
     * Test the audio
     *
     * @return true if the test was successful; otherwise false
     */
	bool runTest();

private:

    /**
     * Callback function for I2S
     */
	void echo(void);

	WM8731 _codec;
	I2S _i2sTx;
	I2S _i2sRx;
	AnalogIn _aIn;

	int _waveIdx;
	int _echoBufPtr;
	int _echoBuf[ECHOLENGTH];
	int _txBuf[16];
	int _rxBuf[16];
};

#endif

