/*
 *  Copyright 2013 Embedded Artists AB
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

#ifndef TESTSHIFTREG_H
#define TESTSHIFTREG_H


/**
 * Test the shift register and the LEDs connected to it on 
 * the LPC4088 Experiment Base Board
 */
class TestShiftreg {
public:
    
    /**
     * Create an interface to the shift register
     *
     */
    TestShiftreg(PinName mosi=p5, PinName miso=p6, PinName sclk=p7, PinName cs=p30);

    /**
     * Test the shift register
     *
     * @return true if the test was successful; otherwise false
     */
	bool runTest();

    /**
     * Set a value in the shift register
     */
    void output(uint8_t value);

private:
    
    SPI _spi;
    DigitalOut _cs;
};

#endif

