/*
 *  Copyright 2013 Embedded Artists AB
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/******************************************************************************
 * Includes
 *****************************************************************************/

#include "mbed.h"
#include "TestShiftreg.h"

/******************************************************************************
 * Defines and typedefs
 *****************************************************************************/


/******************************************************************************
 * Public Functions
 *****************************************************************************/

TestShiftreg::TestShiftreg(PinName mosi, PinName miso, PinName sclk, PinName cs) :
    _spi(mosi, miso, sclk), _cs(cs) {
        
    _cs = 1; // to get it in a known state
    output(0x00);
}

bool TestShiftreg::runTest() {
    output(0x1);
    wait(0.1);
    output(0x2);
    wait(0.1);
    output(0x4);
    wait(0.1);
    output(0x8);
    wait(0.1);
    output(0x10);
    wait(0.1);
    output(0x20);
    wait(0.1);
    output(0x40);
    wait(0.1);
    output(0x80);
    wait(0.1);
    output(0x40);
    wait(0.1);
    output(0x20);
    wait(0.1);
    output(0x10);
    wait(0.1);
    output(0x8);
    wait(0.1);
    output(0x4);
    wait(0.1);
    output(0x2);
    wait(0.1);
    output(0x1);
    wait(0.1);
    output(0x0);
    return true;
}

void TestShiftreg::output(uint8_t value) {
    _cs = 0;
    _spi.write(value);
    _cs = 1;
}

