/*
 *  Copyright 2013 Embedded Artists AB
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

#ifndef TESTRGBLED_H
#define TESTRGBLED_H


/**
 * Test the RGB LED on the LPC4088 Experiment Base Board
 */
class TestRGBLed {
public:

    /**
     * Create an interface to the RGB LED
     *
     * @param red  Pin for the RED LED
     * @param green Pin for the GREEN LED
     * @param blue Pin for the BLUE LED
     * @param button Pin for the User Button on the LPC4088 QuickStart Board
     */
    TestRGBLed(PinName red=p25, PinName green=p28, PinName blue=p26, PinName button=p23);

    /**
     * Blink in pattern to show test start
     */
	void showStartupPattern();

    /**
     * Use the RED or GREEN LEDs to signal failure/success
     */
	void showStatus(bool success);

    /**
     * Wait for the user to press and release the User Button on the
     * LPC4088 QuickStart Board.
     */
	void waitForButtonClick();

    /**
     * Test the RGB LEDs
     *
     * @return true if the test was successful; otherwise false
     */
	bool runTest();

private:

    PinName _redPin;
    PinName _greenPin;
    PinName _bluePin;
    DigitalIn _button;
};

#endif

