/*
 *  Copyright 2013 Embedded Artists AB
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/******************************************************************************
 * Includes
 *****************************************************************************/

#include "mbed.h"
#include "TestTrimpot.h"

/******************************************************************************
 * Defines and typedefs
 *****************************************************************************/

#define MIN_VALUE  (0.010f)
#define MAX_VALUE  (0.990f)

/******************************************************************************
 * Public Functions
 *****************************************************************************/

bool TestTrimpot::runTest() {
    AnalogIn trimpot(p15);
    bool min = false;
    bool max = false;

    printf("Reading trimpot for 5 seconds...\n");  

    // Reads the analog value of the right trimpot every 100ms for
    // up to five seconds or until both end limit have been reached.
    for (int i = 0; i < 50; i++) {
        float f = trimpot.read();
        printf("Trimpot = %.3f\n", f);
        if (f < MIN_VALUE) {
            min = true;
        } else if (f > MAX_VALUE) {
            max = true;
        }
        if (min && max) {
            printf("Test passed\n");
            return true;
        }

        wait(0.1);
    }
    printf("Trimpot does not reach limits (%.3f - %.3f)!\n", MIN_VALUE, MAX_VALUE);
    return false;
}


