/*
 *  Copyright 2013 Embedded Artists AB
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/******************************************************************************
 * Includes
 *****************************************************************************/

#include "mbed.h"
#include "TestRGBLed.h"

/******************************************************************************
 * Defines and typedefs
 *****************************************************************************/

#define LED_ON   0
#define LED_OFF  1

#define BUTTON_PRESSED   0
#define BUTTON_RELEASED  1

/******************************************************************************
 * Public Functions
 *****************************************************************************/

TestRGBLed::TestRGBLed(PinName red, PinName green, PinName blue, PinName button) :
    _redPin(red), _greenPin(green), _bluePin(blue), _button(button) {
       
    _button.mode(PullUp);
}

void TestRGBLed::showStartupPattern() {
    // Have to create the DigitalOut instances here (as opposed to
    // create them in the constructor) as some of the pins are shared 
    // with other functionality on the LPC4088 Experiment Base Board
    DigitalOut ledRed(_redPin);
    DigitalOut ledGreen(_greenPin);
    DigitalOut ledBlue(_bluePin);

    ledRed = LED_OFF;
    ledGreen = LED_OFF;
    ledBlue = LED_OFF;

#if 1
    for (int i = 0; i < 2; i++) {
        ledRed = LED_ON;
        wait(0.1);
        ledRed = LED_OFF;
        ledGreen = LED_ON;
        wait(0.1);
        ledGreen = LED_OFF;
        ledBlue = LED_ON;
        wait(0.1);
        ledBlue = LED_OFF;
    }
#else
    for(int i=0; i<10; i++)
    {
        ledRed = LED_ON;
        wait(0.05);
        ledRed = LED_OFF;
        wait(0.05);
    }
    wait(0.5);
    for(int i=0; i<10; i++)
    {
        ledGreen = LED_ON;
        wait(0.05);
        ledGreen = LED_OFF;
        wait(0.05);
    }
    wait(0.5);
    for(int i=0; i<10; i++)
    {
        ledBlue = LED_ON;
        wait(0.05);
        ledBlue = LED_OFF;
        wait(0.05);
    }
    wait(0.5);    
#endif    
}

void TestRGBLed::showStatus(bool success) {
    // Have to create the DigitalOut instances here (as opposed to
    // create them in the constructor) as some of the pins are shared 
    // with other functionality on the LPC4088 Experiment Base Board
    DigitalOut ledRed(_redPin);
    DigitalOut ledGreen(_greenPin);
    DigitalOut ledBlue(_bluePin);

    ledRed = LED_OFF;
    ledGreen = LED_OFF;
    ledBlue = LED_OFF;
    if (success) {
        ledGreen = LED_ON;
    } else {
        ledRed = LED_ON;
    }
}

void TestRGBLed::waitForButtonClick() {
    // wait for button to be pressed
    while(_button.read() == BUTTON_RELEASED);
    
    // small delay to avoid contact bounce
    wait_ms(40);
    
    // wait for button to be released
    while(_button.read() == BUTTON_PRESSED);
}

bool TestRGBLed::runTest() {
    // Have to create the DigitalOut instances here (as opposed to
    // create them in the constructor) as some of the pins are shared 
    // with other functionality on the LPC4088 Experiment Base Board
    DigitalOut ledRed(_redPin);
    DigitalOut ledGreen(_greenPin);
    DigitalOut ledBlue(_bluePin);

    //printf("LED Tests: All off. Press button to continue\n");
    //ledRed = LED_OFF;
    //ledGreen = LED_OFF;
    //ledBlue = LED_OFF;
    //waitForButtonClick();

    printf("LED Tests: RED on. Press button to continue\n");
    ledRed = LED_ON;
    ledGreen = LED_OFF;
    ledBlue = LED_OFF;
    waitForButtonClick();

    printf("LED Tests: GREEN on. Press button to continue\n");
    ledRed = LED_OFF;
    ledGreen = LED_ON;
    ledBlue = LED_OFF;
    waitForButtonClick();

    printf("LED Tests: BLUE on. Press button to continue\n");
    ledRed = LED_OFF;
    ledGreen = LED_OFF;
    ledBlue = LED_ON;
    waitForButtonClick();

    //printf("LED Tests: All on. Press button to continue\n");
    //ledRed = LED_ON;
    //ledGreen = LED_ON;
    //ledBlue = LED_ON;
    //waitForButtonClick();

    // Turn them off again
    ledRed = LED_OFF;
    ledGreen = LED_OFF;
    ledBlue = LED_OFF;

    return true;
}


