/*
 *  Copyright 2013 Embedded Artists AB
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/******************************************************************************
 * Includes
 *****************************************************************************/

#include "mbed.h"
#include "TestFileSystemSPI.h"
#include "SDFileSystem.h"

/******************************************************************************
 * Defines and typedefs
 *****************************************************************************/


/******************************************************************************
 * Public Functions
 *****************************************************************************/

/*
   Prerequisites:
 
   - For this test to work jumpers JP1..JP6 on the LPC4088 Experiment Base Board
     must all be in positions 2-3, that is closest to the edge of the board.
 
   - The uSD card must be formatted as FAT or FAT32, NTFS will not work.
 
   - This test expects a file with the name message.txt to exist in the
     root folder on the uSD card. The file must be at least 10 bytes in
     size and the first bytes must be eatest2014
*/

bool TestFileSystemSPI::runTest() {
    // The LPC4088 Experiment Base Board does not have the CardDetect signal
    // available so it must be set to NC here to work.
    SDFileSystem spifs(p5, p6, p7, p8, "spi"); // mosi, miso, sclk, cs

    // This test expects a file with the name message.txt to exist in the
    // root folder on the uSD card. The file must be at least 10 bytes in
    // size and the first bytes must be eatest2014.
    FILE* fp = fopen("/spi/message.txt", "r");
    
    if (fp != NULL) {
        char buf[20];
        int num = fread(buf, 1, sizeof(buf), fp);
        if (num >= 10) {
            buf[10] = '\0';
            if (strcmp(buf, "eatest2014") == 0) {
                printf("SPI SD Card works!\n");
                fclose(fp);
                return true;
            }
            printf("Invalid data read from /spi/message.txt\n");
        }
        printf("Failed to read >= 10 bytes from /spi/message.txt\n");
    }
    printf("Failed to open /spi/message.txt\n");
    return false;
}


