/******************************************************************************
 * Includes
 *****************************************************************************/

#include "mbed.h"

#include "LcdController.h"
#include "EaLcdBoard.h"
#include "TextDemo.h"
#include "lpc_winfreesystem14x16.h"
#include "lpc_rom8x8.h"
#include "lpc_rom8x16.h"
#include "lpc_x5x7.h"
#include "lpc_x6x13.h"
#include "lpc_helvr10.h"

/******************************************************************************
 * Typedefs and defines
 *****************************************************************************/

#define NUM_TO_TEST (sizeof(BKGCOLORS)/sizeof(BKGCOLORS[0]))  

/******************************************************************************
 * Local variables
 *****************************************************************************/

static const COLOR_T BKGCOLORS[] = { BLUE, RED, GREEN, YELLOW, CYAN, MAGENTA, LIGHTGRAY };
static const COLOR_T PENCOLORS[] = { WHITE, WHITE, BLACK, BLACK, BLACK, WHITE, RED };

/******************************************************************************
 * Public functions
 *****************************************************************************/
TextDemo::TextDemo(uint8_t *pFrameBuf, uint16_t dispWidth, uint16_t dispHeight)
{
  swim_window_open(&this->_win, 
                   dispWidth, dispHeight,        // full screen
                   (COLOR_T*)pFrameBuf,
                   0,0,dispWidth-1,dispHeight-1, // window position and size
                   0,                            // border
                   WHITE, BLUE, BLACK);          // colors: pen, backgr, forgr
}

void TextDemo::run(EaLcdBoardGPIO& lcdBoard, uint32_t loops, uint32_t delayMs)
{
  printf("TextDemo, %d loops, %dms delay\n", loops, delayMs);
    
  //update framebuffer
  lcdBoard.setFrameBuffer((uint32_t)this->_win.fb);
  
  // Draw strings with the different fonts in different color combinations    
  for (int i = 0; i < NUM_TO_TEST; i++) {
    swim_set_bkg_color(&this->_win, BKGCOLORS[i]);
    swim_set_pen_color(&this->_win, PENCOLORS[i]);
    swim_clear_screen(&this->_win, this->_win.bkg);
    
    int incr = 30;
    int y = incr;
    swim_put_text_xy(&this->_win, "Default Font 0123456789 abcdefghijklmnopqrstuvwxyz", 20, y);
    y += incr;
      
    wait_ms(1000);
    swim_set_font(&this->_win, (FONT_T*)&font_winfreesys14x16);
    swim_put_text_xy(&this->_win, "font_winfreesys14x16 0123456789 abcdefghijklmnopqrstuvwxyz", 20, y);
    y += incr;
      
    wait_ms(1000);
    swim_set_font(&this->_win, (FONT_T*)&font_rom8x8);
    swim_put_text_xy(&this->_win, "font_rom8x8 0123456789 abcdefghijklmnopqrstuvwxyz", 20, y);
    y += incr;
      
    wait_ms(1000);
    swim_set_font(&this->_win, (FONT_T*)&font_rom8x16);
    swim_put_text_xy(&this->_win, "font_rom8x16 0123456789 abcdefghijklmnopqrstuvwxyz", 20, y);
    y += incr;
      
    wait_ms(1000);
    swim_set_font(&this->_win, (FONT_T*)&font_x5x7);
    swim_put_text_xy(&this->_win, "font_x5x7 0123456789 abcdefghijklmnopqrstuvwxyz", 20, y);
    y += incr;
      
    wait_ms(1000);
    swim_set_font(&this->_win, (FONT_T*)&font_x6x13);
    swim_put_text_xy(&this->_win, "font_x6x13 0123456789 abcdefghijklmnopqrstuvwxyz", 20, y);
    y += incr;
      
    wait_ms(1000);
    swim_set_font(&this->_win, (FONT_T*)&font_helvr10);
    swim_put_text_xy(&this->_win, "font_helvr10 0123456789 abcdefghijklmnopqrstuvwxyz", 20, y);
    y += incr;
      
    wait_ms(2500);
  }
  memset((void*)(this->_win.fb), 0, this->_win.xpsize * this->_win.ypsize * sizeof(COLOR_T));
}
