
#ifndef PICTUREDEMO_H
#define PICTUREDEMO_H

#include "EaLcdBoardGPIO.h"

class PictureDemo {
public:

    
    /** Set the address of the frame buffer to use.
     *
     *  It is the content of the frame buffer that is shown on the
     *  display. All the drawing on the frame buffer can be done
     *  'offline' and whenever it should be shown this function
     *  can be called with the address of the offline frame buffer.
     *
     *  @param pFrameBuf  Pointer to the frame buffer, which must be
     *                    3 times as big as the frame size (for tripple
     *                    buffering).
     *         dispWidth  The width of the display (in pixels).
     *         dispHeight The height of the display (in pixels).
     *         loops      Number of loops in the demo code.
     *         delayMs    Delay in milliseconds between schreen updates.
     *
     *  @returns
     *       none
     */
    PictureDemo(uint8_t *pFrameBuf, uint16_t dispWidth, uint16_t dispHeight);
    
    void run(EaLcdBoardGPIO& lcdBoard, int image, uint32_t delayMs);

private:
    int32_t windowX;
    int32_t windowY;
    uint16_t *pFrmBuf;
    uint16_t *pFrmBuf1;
    uint16_t *pFrmBuf2;
    uint16_t *pFrmBuf3;
    
    void drawCentered(const unsigned char* pData, int size, uint32_t delayMs);
};

#endif /* PICTUREDEMO_H */

