/******************************************************************************
 * Includes
 *****************************************************************************/

#include "mbed.h"

#include "LcdController.h"
#include "EaLcdBoard.h"
#include "PictureDemo.h"

#include "Image.h"

extern const unsigned char eaLogo_image[];
extern int eaLogo_image_sz;

extern const unsigned char splash_image[];
extern int splash_image_sz;

/******************************************************************************
 * Typedefs and defines
 *****************************************************************************/

/******************************************************************************
 * Local variables
 *****************************************************************************/

/******************************************************************************
 * External variables
 *****************************************************************************/


/******************************************************************************
 * Local functions
 *****************************************************************************/

void PictureDemo::drawCentered(const unsigned char* pData, int size, uint32_t delayMs)
{
    Image::ImageData_t data;
    int result = Image::decode(pData, size, &data);
    if (result == 0)
    {
        // Draw the image centered on the screen
        unsigned int xoff = (windowX - data.width)/2;
        unsigned int yoff = (windowY - data.height)/2;
        for (int y = 0; y < data.height; y++)
        {
            memcpy(this->pFrmBuf1 + (y+yoff)*windowX + xoff, 
                   data.pixels + y*data.width, 
                   data.width*2);
        }
        
        free(data.pixels);    
    }
    else
    {
        printf("Failed to decode image\n");
    }
}

/******************************************************************************
 * Public functions
 *****************************************************************************/
PictureDemo::PictureDemo(uint8_t *pFrameBuf, uint16_t dispWidth, uint16_t dispHeight)
{
    this->windowX = dispWidth;
    this->windowY = dispHeight;
    this->pFrmBuf  = (uint16_t *)pFrameBuf;
    this->pFrmBuf1 = (uint16_t *)pFrameBuf;
    this->pFrmBuf2 = (uint16_t *)((uint32_t)pFrameBuf + dispWidth*dispHeight*2);
    this->pFrmBuf3 = (uint16_t *)((uint32_t)pFrameBuf + dispWidth*dispHeight*4);
}

void PictureDemo::run(EaLcdBoardGPIO& lcdBoard, int image, uint32_t delayMs)
{
  printf("PictureDemo, image %d, %dms delay\n", image, delayMs);
  
    memset(this->pFrmBuf1, 0xff, windowX*windowY*2);
    switch (image)
    {
        case 1:
            drawCentered(eaLogo_image, eaLogo_image_sz, delayMs);
            break;
        
        default:
            drawCentered(splash_image, splash_image_sz, delayMs);
            break;
    }

    //update framebuffer
    lcdBoard.setFrameBuffer((uint32_t)this->pFrmBuf1);
    
    wait_ms(delayMs);
}

