
#ifndef IMAGE_H
#define IMAGE_H

class Image {
public:

    enum Type {
        BMP = 0,
        PNG,
        UNKNOWN
    };
    
    typedef struct {
        uint16_t* pixels;
        uint32_t  width;
        uint32_t  height;
    } ImageData_t;

    /** Decodes the specified image data
     *
     *  Note that if this function returns a zero, indicating success,
     *  the pixels member of the pDataOut structure must be
     *  deallocated using lpc_free() when no longer needed.
     *
     *  @param pDataIn the image data
     *  @param sizeIn the number of bytes in the pDataIn array
     *  @param pDataOut the decoded image (only valid if 0 is returned)
     *
     *  @returns
     *       0 on success
     *       1 on failure
     */
    static int decode(const unsigned char* pDataIn, unsigned int sizeIn, ImageData_t* pDataOut);

private:

    /** No instance needed
     *
     */
    Image();
    
    static Type imageType(const unsigned char* pDataIn, unsigned int sizeIn);
};

#endif


