#include "mbed.h"

#include "MyWindow.h"
#include "EwPainter.h"

MyWindow::MyWindow(EwWindow* parent) :
    EwWindow(5, 2, 300, 250, parent),
    _changeBtn(130, 200, 40, 20, this),
    _checkBox(0, 0, 80, 25, this),
    _dropDownLst(0, 0, 100, 50, this){

    _changeBtn.setText("Click");
    _changeBtn.setClickedListener(this, &MyWindow::clickListener);

    _checkBox.setText("CheckBox");
    _checkBox.setChangedListener(this, &MyWindow::checkedListener);

    _dropDownLst.addString("First");
    _dropDownLst.addString("Second");
    _dropDownLst.addString("Third");

    _clickCnt = 0;
    _pressed = false;
    _pressX = 0;
    _pressY = 0;

    resizeTo(parent->getWidth()-15, parent->getHeight()-35);
    _changeBtn.moveTo(getWidth()/2-_changeBtn.getWidth()/2,
            getHeight()-_changeBtn.getHeight()-5);

    _checkBox.moveTo(5, 35);

    _dropDownLst.move(getWidth()-_dropDownLst.getWidth()-5, 5);
}

bool MyWindow::paintEvent() {
    char buf[30];
    EwPainter painter;

    painter.setBackgroundColor(EW_LIGHTGRAY);
    painter.clear();

    if (_clickCnt > 0) {
        painter.setColor(EW_BLUE);
        if (_clickCnt == 1) {
            sprintf(buf, "Clicked %d time", _clickCnt);
        }
        else {
            sprintf(buf, "Clicked %d times", _clickCnt);
        }
        painter.drawStringClearEOL(buf, 5, 5);
    }

    if (_pressed) {
        painter.setColor(GUI_DARKRED);
        sprintf(buf, "Touch at %d,%d", _pressX, _pressY);
        painter.drawStringClearEOL(buf, 5, 15);
    }

    return true;
}

bool MyWindow::touchEvent(int x, int y, EwTouchState_t state) {

    if (state == TouchStatePressed) {
        _pressed = true;
        _pressX = x;
        _pressY = y;
    }
    else {
        _pressed = false;
    }

    invalidate();

    return true;
}

void MyWindow::clickListener(EwWindow* w) {
    _clickCnt++;
    invalidate();
}

void MyWindow::checkedListener(EwWindow* w) {
    EwCheckBox* b = (EwCheckBox*)w;

    ewCheckBoxState_t state = b->getState();

    if (state == CheckBoxStateUnchecked) {
        b->setText("Unchecked");
    }
    else {
        b->setText("Checked");
    }

}

