/**
* \file
*
* \brief The image data arrays of each EPD size
*
* Copyright (c) 2012-2014 Pervasive Displays Inc. All rights reserved.
*
*  Authors: Pervasive Displays Inc.
*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*  1. Redistributions of source code must retain the above copyright
*     notice, this list of conditions and the following disclaimer.
*  2. Redistributions in binary form must reproduce the above copyright
*     notice, this list of conditions and the following disclaimer in
*     the documentation and/or other materials provided with the
*     distribution.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include "image_data.h"


#define image_width_270 264 /**< The resolution of 2.7 inch is 264*176 */
#define image_height_270 176 /**< the image array size of 2.7 inch is 176*33 where 33=264/8 */
unsigned char const image_array_270_1[] = {
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 1
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 2
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 3
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 4
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 5
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 6
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 7
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 8
		  0xFF, 0xFF, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 9
		  0xFF, 0xFF, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 10
		  0xFF, 0xFF, 0x00, 0x1F, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 11
		  0xFF, 0xFF, 0x00, 0x1F, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x03, 0xC0, 0xCF, 0xCF, 0xF0, 0x00, 0x3F,  // 12
		  0xFF, 0xFF, 0x00, 0x1F, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x03, 0xC0, 0xCF, 0xCF, 0xF0, 0x00, 0x3F,  // 13
		  0xFF, 0xFF, 0x00, 0x1F, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xF3, 0xFC, 0x0F, 0xC3, 0x33, 0xFF, 0x3F,  // 14
		  0xFF, 0xFF, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xF3, 0xFC, 0x0F, 0xC3, 0x33, 0xFF, 0x3F,  // 15
		  0xFF, 0xFF, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0x33, 0xC0, 0xF0, 0x3F, 0xF3, 0x03, 0x3F,  // 16
		  0xFF, 0xFF, 0x00, 0x06, 0x18, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0x33, 0xC0, 0xF0, 0x3F, 0xF3, 0x03, 0x3F,  // 17
		  0xFF, 0xFF, 0x00, 0x06, 0x18, 0x07, 0xFF, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0x33, 0x30, 0xC3, 0xCC, 0x33, 0x03, 0x3F,  // 18
		  0xFF, 0xFF, 0x00, 0x06, 0x18, 0x07, 0xFF, 0x73, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0x33, 0x30, 0xC3, 0xCC, 0x33, 0x03, 0x3F,  // 19
		  0xFF, 0xFF, 0x00, 0x04, 0x10, 0x07, 0xFF, 0xF3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0x33, 0x33, 0x0F, 0x3C, 0x33, 0x03, 0x3F,  // 20
		  0xFF, 0xFF, 0x00, 0x0C, 0x30, 0x07, 0xFF, 0xF3, 0x01, 0x8E, 0x79, 0xF8, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0x33, 0x33, 0x0F, 0x3C, 0x33, 0x03, 0x3F,  // 21
		  0xFF, 0xFF, 0x00, 0x3C, 0x3C, 0x07, 0xFF, 0xF3, 0x9F, 0xC6, 0xF0, 0xF1, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xF3, 0xC3, 0xC3, 0x33, 0xF3, 0xFF, 0x3F,  // 22
		  0xFF, 0xFF, 0x00, 0x7C, 0x3E, 0x03, 0xFF, 0xF3, 0x9F, 0xE1, 0xF4, 0xF3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xF3, 0xC3, 0xC3, 0x33, 0xF3, 0xFF, 0x3F,  // 23
		  0xFF, 0xFF, 0x00, 0x7C, 0x3E, 0x03, 0xFF, 0xF3, 0x9F, 0xF1, 0xF6, 0x73, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x03, 0x33, 0x33, 0x33, 0x30, 0x00, 0x3F,  // 24
		  0xF0, 0x00, 0x00, 0x78, 0x3C, 0x03, 0xFF, 0xF3, 0x81, 0xF1, 0xE6, 0x78, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x03, 0x33, 0x33, 0x33, 0x30, 0x00, 0x3F,  // 25
		  0xF0, 0x00, 0x00, 0x78, 0x7C, 0x01, 0xFF, 0xF3, 0x9F, 0xE0, 0xE0, 0x7F, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0x33, 0xF3, 0x3F, 0xFF, 0xFF,  // 26
		  0xF8, 0x00, 0x00, 0x18, 0x60, 0x00, 0xFF, 0xF3, 0x9F, 0xEC, 0xCE, 0x3F, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCF, 0x33, 0xF3, 0x3F, 0xFF, 0xFF,  // 27
		  0xF8, 0x00, 0x00, 0x18, 0x60, 0x00, 0xFF, 0xF3, 0x9D, 0xCC, 0x4F, 0x33, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xC0, 0xC3, 0x03, 0xCF, 0xFF, 0x0F, 0xFF,  // 28
		  0xFC, 0x00, 0x00, 0x18, 0x60, 0x00, 0xFF, 0xF3, 0x81, 0x9E, 0x1F, 0x18, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xC0, 0xC3, 0x03, 0xCF, 0xFF, 0x0F, 0xFF,  // 29
		  0xFF, 0x00, 0x00, 0x18, 0xC0, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x33, 0xCC, 0xF3, 0xF0, 0xC0, 0xFC, 0x30, 0xFF,  // 30
		  0xFF, 0x00, 0x00, 0x30, 0xC0, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x33, 0xCC, 0xF3, 0xF0, 0xC0, 0xFC, 0x30, 0xFF,  // 31
		  0xFF, 0x80, 0x00, 0x30, 0xC0, 0x00, 0xFF, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0x00, 0x0C, 0x30, 0x3F, 0x3F, 0x3F, 0xFF,  // 32
		  0xFF, 0xC0, 0x00, 0x30, 0xC0, 0x00, 0xFF, 0xF3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0x00, 0x0C, 0x30, 0x3F, 0x3F, 0x3F, 0xFF,  // 33
		  0xFF, 0xC0, 0x00, 0x30, 0xC0, 0x00, 0xFF, 0xF3, 0x3E, 0x61, 0xC0, 0xC0, 0xE7, 0xD9, 0xF9, 0x80, 0x8F, 0x30, 0x38, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x3F, 0xF0, 0xF0, 0xF3, 0x0F, 0x3F, 0xFF,  // 34
		  0xFF, 0xE0, 0x00, 0x3F, 0xF0, 0x00, 0xFF, 0xF3, 0x9E, 0xC6, 0xB3, 0x4E, 0x67, 0xD8, 0xF1, 0xCF, 0xC7, 0x6C, 0xD1, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x3F, 0xF0, 0xF0, 0xF3, 0x0F, 0x3F, 0xFF,  // 35
		  0xFF, 0xE0, 0x30, 0x7F, 0xF0, 0x07, 0xFF, 0xF3, 0x8E, 0xCF, 0xF3, 0xCF, 0x27, 0xD8, 0xF1, 0xCF, 0xC3, 0x7C, 0xF3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0xC0, 0xC3, 0xFF, 0x3C, 0x33, 0xFF, 0x3F,  // 36
		  0xFF, 0xF0, 0xF8, 0x7F, 0xF0, 0x1F, 0xFF, 0xF3, 0xA6, 0xCF, 0xF3, 0xCF, 0x27, 0xD8, 0x61, 0xCF, 0xD3, 0x7C, 0xF3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0xC0, 0xC3, 0xFF, 0x3C, 0x33, 0xFF, 0x3F,  // 37
		  0xFF, 0xF9, 0xFC, 0x7F, 0xF0, 0x7F, 0xFF, 0xF3, 0xB2, 0xE1, 0xF3, 0xC0, 0x67, 0xD9, 0x69, 0xC0, 0xD9, 0x7C, 0xF8, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xCC, 0xF3, 0x00, 0x30, 0x00, 0x30, 0x3F,  // 38
		  0xFF, 0xFF, 0xFC, 0x3F, 0xE1, 0xFF, 0xFF, 0xF3, 0xB0, 0xFC, 0xF3, 0xCC, 0xE7, 0xD9, 0x09, 0xCF, 0xDC, 0x7C, 0xFF, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0C, 0xCC, 0xF3, 0x00, 0x30, 0x00, 0x30, 0x3F,  // 39
		  0xFF, 0xFF, 0xFE, 0x00, 0x03, 0xFF, 0xFF, 0xF3, 0xB8, 0xFE, 0xF3, 0xCE, 0x67, 0xD9, 0x99, 0xCF, 0xDE, 0x7C, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x30, 0x03, 0xFC, 0x33, 0xCF, 0xF3, 0xFF,  // 40
		  0xFF, 0xFF, 0xFE, 0x00, 0x07, 0xFF, 0xFF, 0xF3, 0xBC, 0xCC, 0xF3, 0xCF, 0x33, 0x99, 0x99, 0xCF, 0xDF, 0x7C, 0xF3, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x30, 0x03, 0xFC, 0x33, 0xCF, 0xF3, 0xFF,  // 41
		  0xFF, 0xFF, 0xFF, 0x00, 0x07, 0xFF, 0xFF, 0xE1, 0x3E, 0xE1, 0xF3, 0xC7, 0x90, 0x39, 0xF9, 0xC0, 0x9F, 0x7C, 0xF8, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0xCF, 0xCF, 0x30, 0xFC, 0xFC, 0xF3, 0x3F,  // 42
		  0xFF, 0xFF, 0xFF, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0xCF, 0xCF, 0x30, 0xFC, 0xFC, 0xF3, 0x3F,  // 43
		  0xFF, 0xFF, 0xFF, 0x80, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0xC0, 0x03, 0x03, 0xCF, 0x3F, 0xF3, 0xFF,  // 44
		  0xFF, 0xFF, 0xFF, 0x80, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0xC0, 0x03, 0x03, 0xCF, 0x3F, 0xF3, 0xFF,  // 45
		  0xFF, 0xFF, 0xFF, 0xC0, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x0F, 0x03, 0xF0, 0xCC, 0x03, 0x00, 0x3F,  // 46
		  0xFF, 0xFF, 0xFF, 0xE0, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0x0F, 0x03, 0xF0, 0xCC, 0x03, 0x00, 0x3F,  // 47
		  0xFF, 0xFF, 0xFF, 0xF0, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x33, 0xF3, 0x0C, 0xC0, 0xF3, 0xFF, 0x3F,  // 48
		  0xFF, 0xFF, 0xFF, 0xF8, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x33, 0xF3, 0x0C, 0xC0, 0xF3, 0xFF, 0x3F,  // 49
		  0xFF, 0xFF, 0xFF, 0xFC, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0xCC, 0xF0, 0xFF, 0x3F, 0xF0, 0x3F, 0xFF,  // 50
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xCC, 0xCC, 0xF0, 0xFF, 0x3F, 0xF0, 0x3F, 0xFF,  // 51
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC3, 0x33, 0xF0, 0x33, 0xCC, 0x00, 0x30, 0x3F,  // 52
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC3, 0x33, 0xF0, 0x33, 0xCC, 0x00, 0x30, 0x3F,  // 53
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0x0C, 0xFF, 0x3F, 0x0F, 0xFF,  // 54
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0x0C, 0xFF, 0x3F, 0x0F, 0xFF,  // 55
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x03, 0x3F, 0x00, 0x00, 0x33, 0x03, 0xFF,  // 56
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x03, 0x3F, 0x00, 0x00, 0x33, 0x03, 0xFF,  // 57
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xF3, 0x03, 0xF0, 0x3C, 0x3F, 0x0C, 0xFF,  // 58
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xF3, 0x03, 0xF0, 0x3C, 0x3F, 0x0C, 0xFF,  // 59
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0x33, 0xC0, 0xFF, 0x30, 0x00, 0x3F, 0xFF,  // 60
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0x33, 0xC0, 0xFF, 0x30, 0x00, 0x3F, 0xFF,  // 61
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0x33, 0xF0, 0xCC, 0x00, 0x0C, 0xCF, 0x3F,  // 62
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0x33, 0xF0, 0xCC, 0x00, 0x0C, 0xCF, 0x3F,  // 63
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x30, 0x33, 0xCF, 0xCC, 0x0F, 0xC0, 0x00, 0xFF,  // 64
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x07, 0xFF, 0xFF, 0x30, 0x33, 0xCF, 0xCC, 0x0F, 0xC0, 0x00, 0xFF,  // 65
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0x3F, 0xF3, 0x0F, 0x3C, 0x30, 0xF0, 0xC3, 0x3F,  // 66
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0x3F, 0xF3, 0x0F, 0x3C, 0x30, 0xF0, 0xC3, 0x3F,  // 67
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, 0x03, 0x30, 0x00, 0xCC, 0xFC, 0x03, 0xFF,  // 68
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x07, 0xFF, 0xF8, 0x07, 0xFF, 0x00, 0x03, 0x30, 0x00, 0xCC, 0xFC, 0x03, 0xFF,  // 69
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x3F, 0xFF, 0xF0, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 70
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x07, 0xFF, 0xC0, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 71
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 72
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x7F, 0xE0, 0x30, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 73
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x07, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 74
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x3F, 0xFF, 0xF8, 0x00, 0x20, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0x83, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 75
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x03, 0xFF, 0xFF, 0xC0, 0x01, 0xF0, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 76
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x01, 0xFF, 0xFF, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x07, 0xFF, 0xFE, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 77
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x3F, 0xFC, 0x00, 0x3F, 0xF8, 0x00, 0x00, 0x07, 0xFF, 0xFC, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 78
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x0F, 0xF8, 0x01, 0xFF, 0xFC, 0x00, 0x00, 0x03, 0xFF, 0xF8, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 79
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x87, 0xE0, 0x03, 0xFF, 0xFC, 0x00, 0x00, 0x03, 0xFF, 0xF0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 80
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC7, 0x80, 0x1F, 0xFF, 0xFE, 0x00, 0x00, 0x03, 0xFF, 0xC0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 81
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE3, 0x00, 0x7F, 0xFF, 0xFE, 0x00, 0x00, 0x01, 0xFF, 0x80, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 82
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x01, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x01, 0xFE, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 83
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x07, 0xFF, 0xF8, 0xFF, 0x00, 0x00, 0x01, 0xF8, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 84
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x1F, 0xFF, 0xE0, 0x7F, 0x00, 0x00, 0x01, 0xF0, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 85
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x3F, 0xFE, 0x00, 0x7F, 0x80, 0x00, 0x01, 0xC0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 86
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x1F, 0xFF, 0xF8, 0xFF, 0xF0, 0x00, 0x3F, 0x80, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 87
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x1F, 0xFF, 0xF8, 0xFF, 0xC0, 0x00, 0x3F, 0x80, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 88
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x07, 0xFF, 0xFF, 0xFF, 0xF8, 0xFE, 0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 89
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xE0, 0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 90
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x3F, 0xFF, 0xFF, 0xFF, 0xF1, 0xFC, 0x00, 0x00, 0x0F, 0xFF, 0x80, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 91
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xFF, 0xFF, 0xFF, 0xF8, 0x01, 0xFC, 0x00, 0x00, 0xFF, 0xFF, 0x80, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 92
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x1F, 0xFF, 0xFF, 0xFE, 0x00, 0x0F, 0xF8, 0x00, 0x07, 0xFF, 0xFF, 0x80, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 93
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xFF, 0xFF, 0xC0, 0x03, 0xFF, 0xC0, 0x00, 0x3F, 0xFF, 0xFF, 0x80, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 94
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x83, 0xFF, 0xFF, 0xF8, 0x00, 0xFF, 0xFE, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0x80, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 95
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x1F, 0xFF, 0xFF, 0x00, 0x3F, 0xFF, 0xF0, 0x00, 0x3F, 0xFF, 0xFF, 0xFC, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 96
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0xF8, 0x07, 0xFF, 0xFF, 0x80, 0x3E, 0x3F, 0xFF, 0xFF, 0x80, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 97
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC1, 0xFF, 0xFF, 0x80, 0x7F, 0xFF, 0xFF, 0x83, 0xFF, 0x3F, 0xFF, 0xF0, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 98
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xFF, 0xFC, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1F, 0xF0, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 99
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x1F, 0xFF, 0xF0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 100
		  0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0x81, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 101
		  0xFF, 0xFF, 0xFF, 0xFF, 0xC1, 0xFF, 0xFE, 0x0F, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 102
		  0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xFF, 0xF8, 0x7F, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0x80, 0x00, 0x1C, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 103
		  0xFF, 0xFF, 0xFF, 0xFE, 0x1F, 0xFF, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF, 0xE1, 0xFF, 0xFF, 0xC4, 0x3F, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 104
		  0xFF, 0xFF, 0xFF, 0xF8, 0x7F, 0xFF, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0x87, 0xFF, 0x3F, 0xC7, 0xFF, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 105
		  0xFF, 0xFF, 0xFF, 0xE1, 0xFF, 0xFC, 0x1F, 0xFF, 0xFF, 0xFF, 0xFE, 0x1F, 0xFE, 0x3F, 0xC7, 0xFF, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 106
		  0xFF, 0xFF, 0xFF, 0x87, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFC, 0x3F, 0xF8, 0x7F, 0xC7, 0xFF, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 107
		  0xFF, 0xFF, 0xFF, 0x1F, 0xFF, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0xF1, 0xFF, 0xC7, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 108
		  0xFF, 0xFF, 0xFC, 0x3F, 0xFF, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xC3, 0xFF, 0xE3, 0xFF, 0x8F, 0xFE, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 109
		  0xFF, 0xFF, 0xF8, 0xFF, 0xFE, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xFF, 0x8F, 0xFF, 0x0F, 0xF8, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 110
		  0xFF, 0xFF, 0xE1, 0xFF, 0xF8, 0x7F, 0xFF, 0xFF, 0xFF, 0xF8, 0x3F, 0xFF, 0x1F, 0xFE, 0x1F, 0xC0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 111
		  0xFF, 0xFF, 0xC7, 0xFF, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xFC, 0x7F, 0xFC, 0x3E, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 112
		  0xFF, 0xFF, 0x8F, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0x03, 0xFF, 0xF0, 0xFF, 0xF0, 0x60, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 113
		  0xFF, 0xFE, 0x3F, 0xFE, 0x1F, 0xFF, 0xFF, 0xFF, 0xF0, 0x0F, 0xFF, 0xE1, 0xFF, 0xC0, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 114
		  0xFF, 0xFC, 0x7F, 0xFC, 0x3F, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0x87, 0xFF, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 115
		  0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x07, 0xFF, 0xFF, 0x1F, 0xFE, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 116
		  0xFF, 0xF1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x7F, 0xFF, 0xFC, 0x3F, 0xFE, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 117
		  0xFF, 0xC7, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x0F, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 118
		  0xFF, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0xFF, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x47, 0x0F, 0xFF,  // 119
		  0xFF, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xC7, 0x0F, 0xFF,  // 120
		  0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF3, 0x96, 0x4F, 0xFF,  // 121
		  0xFC, 0x7F, 0xFF, 0xFF, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x3C, 0x1E, 0x0F, 0x80, 0x7F, 0xCF, 0x0F, 0xE3, 0xF3, 0x96, 0x1F, 0xFF,  // 122
		  0xF8, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0x83, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x3C, 0x1C, 0x07, 0x80, 0x1F, 0x8E, 0x07, 0x81, 0xF3, 0x94, 0x9F, 0xFF,  // 123
		  0xF8, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFC, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x98, 0x18, 0xE3, 0x8F, 0x1F, 0x0C, 0x63, 0x98, 0xF3, 0x94, 0x9F, 0xFF,  // 124
		  0xFC, 0x00, 0x00, 0x7F, 0x1F, 0xFF, 0xFF, 0xFF, 0x80, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x99, 0x19, 0xF3, 0x1F, 0x1E, 0x1C, 0xE3, 0x18, 0xF3, 0x91, 0x9F, 0xFF,  // 125
		  0xFF, 0xFF, 0xFF, 0xFF, 0x3F, 0xFF, 0xFF, 0xF8, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x99, 0x38, 0xFF, 0x1F, 0x1C, 0x1F, 0xC3, 0x18, 0xE7, 0x31, 0x3F, 0xFF,  // 126
		  0xFF, 0xFF, 0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x92, 0x38, 0x3F, 0x1E, 0x39, 0x1F, 0x06, 0x38, 0xE7, 0x33, 0x3F, 0xFF,  // 127
		  0xFF, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0x80, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x92, 0x3C, 0x0F, 0x00, 0x33, 0x1F, 0x0E, 0x38, 0xFF, 0xFF, 0xFF, 0xFF,  // 128
		  0xFF, 0xFF, 0xFF, 0xFC, 0x7E, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x92, 0x3F, 0x07, 0x00, 0xE7, 0x1F, 0xC6, 0x38, 0xFF, 0xFF, 0xFF, 0xFF,  // 129
		  0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x86, 0x3F, 0xC7, 0x1F, 0xC0, 0x0F, 0xC6, 0x31, 0xFF, 0xFF, 0xFF, 0xFF,  // 130
		  0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF1, 0x86, 0x27, 0xE7, 0x1F, 0xC0, 0x09, 0xC6, 0x31, 0xFF, 0xFF, 0xFF, 0xFF,  // 131
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF1, 0x8C, 0x63, 0xC6, 0x3F, 0xFE, 0x38, 0x86, 0x33, 0xFF, 0xFF, 0xFF, 0xFF,  // 132
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF1, 0x8C, 0x70, 0x0E, 0x3F, 0xFE, 0x3C, 0x0F, 0x03, 0xFF, 0xFF, 0xFF, 0xFF,  // 133
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF1, 0x9C, 0x78, 0x1E, 0x3F, 0xFE, 0x3E, 0x1F, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF,  // 134
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 135
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 136
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 137
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 138
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 139
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 140
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 141
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 142
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 143
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF,  // 144
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF,  // 145
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xFF, 0xFC, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF,  // 146
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xFF, 0xFC, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF,  // 147
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x07, 0xFF, 0xFC, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF,  // 148
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0xFF, 0xFC, 0x1C, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF,  // 149
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x0F, 0xFF, 0xF8, 0x1F, 0x81, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF,  // 150
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x0F, 0xFF, 0xF8, 0x3F, 0x81, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 151
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0x03, 0x87, 0xE1, 0xFC, 0x1F, 0x8F, 0x03, 0xFF, 0xC0, 0x7E, 0x0C, 0x0F, 0xF8, 0x3F, 0x81, 0xF8, 0x1C, 0x3F, 0xE0, 0x70, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 152
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFC, 0x01, 0x87, 0xC1, 0xFC, 0x1F, 0x0C, 0x01, 0xFF, 0x00, 0x1E, 0x08, 0x07, 0xF8, 0x3F, 0x81, 0xE0, 0x04, 0x3F, 0x80, 0x10, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 153
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x7F, 0xF8, 0x00, 0x07, 0xC1, 0xFC, 0x1F, 0x08, 0x01, 0xFE, 0x00, 0x1E, 0x00, 0x03, 0xF8, 0x3F, 0x83, 0xC0, 0x00, 0x3F, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 154
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xF0, 0x00, 0x07, 0xC1, 0xF8, 0x3F, 0x00, 0x00, 0xFC, 0x00, 0x1C, 0x00, 0x03, 0xF0, 0x3F, 0x83, 0xC0, 0x00, 0x3E, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 155
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xF0, 0x3C, 0x0F, 0xC3, 0xF8, 0x3F, 0x01, 0xC0, 0xF8, 0x1F, 0x3C, 0x03, 0x83, 0xF0, 0x7F, 0x03, 0x81, 0xE0, 0x3E, 0x07, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 156
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xE0, 0x7E, 0x0F, 0x83, 0xF8, 0x3E, 0x03, 0xE0, 0xF8, 0x3F, 0xFC, 0x07, 0x83, 0xF0, 0x7E, 0x07, 0x03, 0xF0, 0x7C, 0x0F, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 157
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xE0, 0xFE, 0x0F, 0x83, 0xF8, 0x3E, 0x07, 0xE0, 0xF0, 0x7F, 0xFC, 0x0F, 0x83, 0xF0, 0x00, 0x0F, 0x07, 0xF0, 0x7C, 0x1F, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 158
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC1, 0xFF, 0xC0, 0xFE, 0x0F, 0x83, 0xF8, 0x3E, 0x0F, 0xE1, 0xF0, 0x7F, 0xFC, 0x1F, 0x83, 0xF0, 0x00, 0x1F, 0x07, 0xF0, 0x78, 0x1F, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 159
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC1, 0xFF, 0xC1, 0xFE, 0x0F, 0x83, 0xF0, 0x7E, 0x0F, 0xC1, 0xE0, 0x7F, 0xF8, 0x1F, 0x83, 0xE0, 0x00, 0x3E, 0x0F, 0xF0, 0x78, 0x3F, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 160
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC1, 0xFF, 0xC1, 0xFC, 0x1F, 0x83, 0xF0, 0x7E, 0x1F, 0xC1, 0xE0, 0xFF, 0xF8, 0x3F, 0x83, 0xE0, 0x00, 0xFE, 0x0F, 0xF0, 0x78, 0x3F, 0x83, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 161
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC1, 0xFF, 0x81, 0xFC, 0x1F, 0x07, 0xF0, 0x7C, 0x1F, 0xC1, 0xE0, 0xFF, 0xF8, 0x3F, 0x83, 0xE0, 0xFF, 0xFE, 0x0F, 0xE0, 0xF8, 0x3F, 0x83, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 162
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC1, 0xFF, 0x81, 0xFC, 0x1F, 0x07, 0xE0, 0x7C, 0x1F, 0xC1, 0xE0, 0xFF, 0xF8, 0x3F, 0x07, 0xE0, 0xFF, 0xFE, 0x0F, 0xE0, 0xF0, 0x3F, 0x83, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 163
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x81, 0xFF, 0x81, 0xF8, 0x1F, 0x07, 0xE0, 0x7C, 0x1F, 0xC3, 0xE0, 0xFF, 0xF8, 0x7F, 0x07, 0xE0, 0xFF, 0xFE, 0x0F, 0xC0, 0xF0, 0x3F, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 164
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x83, 0xFF, 0x81, 0xF0, 0x1F, 0x07, 0xC0, 0xFC, 0x1F, 0x83, 0xE0, 0xFF, 0xF0, 0x7F, 0x07, 0xC0, 0xFF, 0xFE, 0x0F, 0xC0, 0xF0, 0x3E, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 165
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x83, 0xFF, 0x81, 0xF0, 0x3F, 0x07, 0x80, 0xFC, 0x3F, 0x83, 0xE0, 0xFE, 0xF0, 0x7F, 0x07, 0xC1, 0xFF, 0xFE, 0x0F, 0x80, 0xF0, 0x3C, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 166
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x01, 0x80, 0xC0, 0x3F, 0x02, 0x00, 0xF8, 0x3F, 0x83, 0xE0, 0x78, 0xF0, 0x7F, 0x07, 0xC1, 0xFF, 0xFE, 0x06, 0x01, 0xF8, 0x18, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 167
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x01, 0x80, 0x00, 0x3F, 0x00, 0x00, 0xF8, 0x3F, 0x83, 0xE0, 0x00, 0xF0, 0x7E, 0x0F, 0x81, 0xFF, 0xFE, 0x00, 0x01, 0xF8, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 168
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x03, 0xC0, 0x0C, 0x3F, 0x00, 0x30, 0xF8, 0x3F, 0x07, 0xF0, 0x00, 0xE0, 0xFE, 0x0F, 0x81, 0xFF, 0xFF, 0x00, 0x21, 0xF8, 0x01, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 169
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x03, 0xE0, 0x18, 0x3F, 0x80, 0x70, 0xF8, 0x3F, 0x07, 0xF8, 0x01, 0xE0, 0xFE, 0x0F, 0x83, 0xFF, 0xFF, 0x00, 0xC1, 0xFC, 0x03, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 170
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x07, 0xF8, 0x7C, 0x7F, 0xC1, 0xF1, 0xF8, 0x7F, 0x0F, 0xFE, 0x0F, 0xF1, 0xFF, 0x1F, 0xC7, 0xFF, 0xFF, 0xC3, 0xE3, 0xFF, 0x0F, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 171
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 172
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 173
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 174
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 175
		  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF   // 176
		};

unsigned char const image_array_270_2[] = {
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 1
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 2
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 3
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 4
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 5
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 6
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 7
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 8
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 9
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 10
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 11
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 12
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 13
  0xFF, 0xFF, 0xF1, 0xFF, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x87, 0xFE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x18, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 14
  0xFF, 0xFF, 0x80, 0x3F, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0x87, 0xFC, 0x3F, 0xFF, 0xFF, 0xFF, 0xE0, 0x7E, 0x18, 0x7F, 0xF0, 0xFF, 0xFF, 0xFF, 0xF0, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 15
  0xFF, 0xFF, 0x00, 0x3F, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0x87, 0xFC, 0x3F, 0xFF, 0xC3, 0xFF, 0xE0, 0x7E, 0x18, 0x7F, 0xF0, 0xFF, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 16
  0xFF, 0xFE, 0x00, 0x3F, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0x87, 0xFE, 0x7F, 0xFF, 0xC3, 0xFF, 0xC0, 0x7E, 0x18, 0x7F, 0xF0, 0xFF, 0xFF, 0xFF, 0xC0, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 17
  0xFF, 0xFC, 0x1F, 0xFF, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0xF0, 0xFF, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0xC3, 0xFF, 0xC0, 0x3E, 0x18, 0x7F, 0xF0, 0xFF, 0xFF, 0xFF, 0x87, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 18
  0xFF, 0xF8, 0x3F, 0xFE, 0x0F, 0x87, 0xE0, 0xFC, 0x67, 0xF0, 0xE3, 0x0F, 0x87, 0x1E, 0x3F, 0x0F, 0xC0, 0xFF, 0xC4, 0x3E, 0x18, 0x7F, 0xF0, 0xE3, 0x0F, 0xFF, 0x07, 0xC1, 0xC6, 0x1F, 0xE1, 0xFF, 0xFF,  // 19
  0xFF, 0xF8, 0x7F, 0xF8, 0x03, 0x87, 0x80, 0x3C, 0x47, 0xF0, 0xE0, 0x07, 0x86, 0x1C, 0x3C, 0x03, 0x00, 0xFF, 0xC4, 0x3E, 0x18, 0x7F, 0xF0, 0xE0, 0x07, 0xFF, 0x0F, 0xE1, 0xC0, 0x0F, 0x80, 0x7F, 0xFF,  // 20
  0xFF, 0xF8, 0x7F, 0xF0, 0x03, 0x87, 0x00, 0x3C, 0x07, 0xF0, 0xE0, 0x03, 0x84, 0x1C, 0x38, 0x01, 0x00, 0xFF, 0x86, 0x3E, 0x18, 0x7F, 0xF0, 0xE0, 0x03, 0xFF, 0x0F, 0xE1, 0xC0, 0x07, 0x00, 0x3F, 0xFF,  // 21
  0xFF, 0xF8, 0x7F, 0xF0, 0xE1, 0x87, 0x0E, 0x1C, 0x07, 0xF0, 0xE0, 0x83, 0x84, 0x3C, 0x38, 0xE1, 0xC3, 0xFF, 0x86, 0x1E, 0x18, 0x7F, 0xF0, 0xE0, 0x83, 0xFF, 0x0F, 0xE1, 0xC1, 0x07, 0x1C, 0x3F, 0xFF,  // 22
  0xFF, 0xF8, 0x7F, 0xE1, 0xF0, 0x86, 0x1F, 0x0C, 0x1F, 0xF0, 0xE1, 0xC3, 0x80, 0x7C, 0x30, 0xF1, 0xC3, 0xFF, 0x8E, 0x1E, 0x18, 0x60, 0x70, 0xE1, 0xC3, 0x03, 0x0F, 0xE1, 0xC3, 0x86, 0x1E, 0x3F, 0xFF,  // 23
  0xFF, 0xF8, 0x7F, 0xE1, 0xF0, 0x86, 0x1F, 0x0C, 0x3F, 0xF0, 0xE1, 0xC3, 0x80, 0x7C, 0x30, 0x00, 0xC3, 0xFF, 0x00, 0x1E, 0x18, 0x60, 0x30, 0xE1, 0xC3, 0x01, 0x0F, 0xE1, 0xC3, 0x86, 0x00, 0x1F, 0xFF,  // 24
  0xFF, 0xF8, 0x7F, 0xE1, 0xF0, 0x86, 0x1F, 0x0C, 0x3F, 0xF0, 0xE1, 0xC3, 0x80, 0x7C, 0x30, 0x00, 0xC3, 0xFF, 0x00, 0x0E, 0x18, 0x60, 0x30, 0xE1, 0xC3, 0x01, 0x0F, 0xE1, 0xC3, 0x86, 0x00, 0x1F, 0xFF,  // 25
  0xFF, 0xF8, 0x3F, 0xE1, 0xF0, 0x86, 0x1F, 0x0C, 0x3F, 0xF0, 0xE1, 0xC3, 0x80, 0x3C, 0x30, 0xFF, 0xC3, 0xFF, 0x00, 0x0E, 0x18, 0x7F, 0xF0, 0xE1, 0xC3, 0xFF, 0x07, 0xC1, 0xC3, 0x86, 0x1F, 0xFF, 0xFF,  // 26
  0xFF, 0xFC, 0x1F, 0xF0, 0xE1, 0x87, 0x0E, 0x1C, 0x3F, 0xF0, 0xE1, 0xC3, 0x84, 0x1C, 0x30, 0xFF, 0xC3, 0xFE, 0x1F, 0x0E, 0x18, 0x7F, 0xF0, 0xE1, 0xC3, 0xFF, 0x83, 0x83, 0xC3, 0x86, 0x1F, 0xFF, 0xFF,  // 27
  0xFF, 0xFE, 0x00, 0x70, 0x01, 0x87, 0x00, 0x1C, 0x3F, 0xF0, 0xE1, 0xC3, 0x86, 0x1C, 0x38, 0x01, 0xC0, 0xFE, 0x1F, 0x06, 0x18, 0x7F, 0xF0, 0xE1, 0xC3, 0xFF, 0xC0, 0x03, 0xC3, 0x87, 0x00, 0x3F, 0xFF,  // 28
  0xFF, 0xFF, 0x00, 0x78, 0x03, 0x87, 0x80, 0x3C, 0x3F, 0xF0, 0xE1, 0xC3, 0x86, 0x0C, 0x3C, 0x01, 0xC0, 0xFE, 0x1F, 0x86, 0x18, 0x7F, 0xF0, 0xE1, 0xC3, 0xFF, 0xC0, 0x07, 0xC3, 0x87, 0x80, 0x3F, 0xFF,  // 29
  0xFF, 0xFF, 0x80, 0x7C, 0x07, 0x87, 0xC0, 0x7C, 0x3F, 0xF0, 0xE1, 0xC3, 0x87, 0x0C, 0x3E, 0x01, 0xE0, 0xFC, 0x1F, 0x86, 0x18, 0x7F, 0xF0, 0xE1, 0xC3, 0xFF, 0xF0, 0x1F, 0xC3, 0x87, 0xC0, 0x3F, 0xFF,  // 30
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 31
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 32
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 33
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 34
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 35
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 36
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 37
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 38
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 39
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 40
  0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 41
  0xFF, 0xFF, 0xF8, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0x0E, 0x3F, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 42
  0xFF, 0xFC, 0x00, 0xCF, 0x0E, 0x3F, 0xFF, 0xF0, 0x3F, 0x08, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 43
  0xFF, 0x00, 0x3F, 0xE0, 0x00, 0x0F, 0xFF, 0x03, 0xFF, 0xC0, 0x03, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 44
  0xE0, 0x1F, 0xFF, 0xF3, 0xC3, 0xE7, 0xF0, 0x1F, 0xFF, 0xF0, 0x08, 0xC7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 45
  0xE7, 0xFF, 0xFF, 0xFC, 0xF0, 0xE0, 0x01, 0xFF, 0xFF, 0xFC, 0x7E, 0x31, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 46
  0xE7, 0xFF, 0xFF, 0xFE, 0x38, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0x3F, 0x98, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 47
  0xE3, 0xFF, 0xFF, 0xFF, 0x9E, 0x19, 0xCF, 0xFF, 0xFF, 0xFF, 0x8F, 0xE6, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 48
  0xE1, 0xFF, 0xFF, 0xFF, 0xCF, 0x84, 0xE3, 0xFF, 0xFF, 0xFF, 0xE3, 0xF9, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 49
  0xE4, 0x7F, 0xFF, 0xFF, 0xE3, 0xC0, 0x79, 0xFF, 0xFF, 0xFF, 0xF8, 0xFE, 0x63, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 50
  0xE7, 0x3F, 0xFF, 0xFF, 0xF9, 0xF0, 0x3C, 0x7F, 0xFF, 0xFF, 0xFE, 0x7F, 0x98, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 51
  0xE7, 0x9F, 0xFF, 0xFF, 0xFC, 0x78, 0x0F, 0x3F, 0xFF, 0xFF, 0xFF, 0x1F, 0xE6, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 52
  0xE7, 0xCF, 0xFF, 0xFF, 0xFF, 0x39, 0xA7, 0x8F, 0xFF, 0xFF, 0xFF, 0xCF, 0xF1, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 53
  0xE7, 0xE7, 0xFF, 0xFF, 0xFF, 0x83, 0xD1, 0xE7, 0xFF, 0xFF, 0xFF, 0xEF, 0xFC, 0x63, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 54
  0xE7, 0xF3, 0xFF, 0xFF, 0xFF, 0xE7, 0xEC, 0xF1, 0xFF, 0xFF, 0xFF, 0xE7, 0xFF, 0x18, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 55
  0xE7, 0xF9, 0xFF, 0xFF, 0xFF, 0xF3, 0xF6, 0x3C, 0xFF, 0xFF, 0xFF, 0xE7, 0xFF, 0xC4, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 56
  0xE7, 0xFC, 0xFF, 0xFF, 0xFF, 0xF9, 0xFB, 0x9E, 0x3F, 0xFF, 0xFF, 0xC7, 0xFF, 0xF7, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 57
  0xE7, 0xFE, 0x7F, 0xFF, 0xFF, 0xFD, 0xF9, 0xCF, 0x9F, 0xFF, 0xFF, 0x8F, 0xFF, 0xE7, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 58
  0xF7, 0xFF, 0x3F, 0xFF, 0xFF, 0xFE, 0xFC, 0xF0, 0x07, 0xFF, 0xFE, 0x0F, 0xFF, 0xCE, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 59
  0xF7, 0xFF, 0x9F, 0xFF, 0xFF, 0xFE, 0x7E, 0x80, 0x01, 0xFF, 0xC0, 0x3F, 0xFC, 0x10, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 60
  0xF3, 0xFF, 0xCF, 0xFF, 0xFF, 0xFF, 0x7E, 0x07, 0xE4, 0xF8, 0x00, 0xFF, 0x80, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 61
  0xF1, 0xFF, 0xE7, 0xFF, 0xFF, 0xFF, 0x3F, 0x3F, 0xE6, 0x00, 0x0F, 0xE0, 0x00, 0x06, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 62
  0xF0, 0xFF, 0xF7, 0xFF, 0xFF, 0xFF, 0xBF, 0xBF, 0xE0, 0x00, 0x7F, 0x00, 0x00, 0x38, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 63
  0xF2, 0x7F, 0xF3, 0xFF, 0xFF, 0xFF, 0x9F, 0x9E, 0x03, 0x07, 0xE0, 0x00, 0x00, 0x02, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x1F, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xFF, 0xF0, 0x7F,  // 64
  0xF3, 0x3F, 0xF9, 0xFF, 0xFF, 0xFF, 0xDF, 0xC0, 0x60, 0x7C, 0x00, 0x00, 0x0F, 0xDE, 0x7F, 0xFF, 0xFF, 0xF0, 0x1F, 0xFC, 0x00, 0x00, 0x3F, 0xE0, 0x03, 0xFF, 0xFF, 0xFF, 0x00, 0x1F, 0xFF, 0x80, 0x1F,  // 65
  0xF3, 0x9F, 0xFD, 0xFF, 0xF9, 0xFF, 0xDF, 0xE6, 0x0F, 0x80, 0x00, 0x00, 0xCF, 0x4E, 0x7F, 0xFF, 0xFF, 0xC0, 0x1F, 0xF8, 0x00, 0x00, 0x3F, 0x80, 0x01, 0xFF, 0xFF, 0xFC, 0x00, 0x0F, 0xFF, 0x00, 0x0F,  // 66
  0xF3, 0xCF, 0xFC, 0xFF, 0xE1, 0xFF, 0xCF, 0xF0, 0x70, 0x01, 0x00, 0x1E, 0x07, 0xEE, 0x7F, 0xFF, 0xFF, 0x00, 0x1F, 0xF8, 0x00, 0x00, 0x3F, 0x00, 0x00, 0xFF, 0xFF, 0xF8, 0x00, 0x07, 0xFC, 0x00, 0x07,  // 67
  0xF3, 0xE7, 0xFE, 0xFF, 0xED, 0xFF, 0xCF, 0xFC, 0x00, 0xD8, 0x07, 0xC8, 0x0E, 0x06, 0x7F, 0xFF, 0xFE, 0x00, 0x3F, 0xF8, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x7F, 0xFF, 0xF0, 0x00, 0x03, 0xF8, 0x00, 0x07,  // 68
  0xF1, 0xF3, 0xFE, 0xFF, 0xE1, 0xFF, 0xCF, 0xFF, 0x0F, 0x00, 0x18, 0x00, 0xF0, 0x86, 0x7F, 0xFF, 0xFC, 0x00, 0x3F, 0xF8, 0x00, 0x00, 0x7C, 0x07, 0xE0, 0x7F, 0xFF, 0xE0, 0x3F, 0x03, 0xF8, 0x1E, 0x03,  // 69
  0xF0, 0xF9, 0xFE, 0x7F, 0xC7, 0xFF, 0xCF, 0xFF, 0xE0, 0x00, 0x00, 0x06, 0x00, 0x82, 0xFF, 0xFF, 0xFE, 0x00, 0x3F, 0xFF, 0xFF, 0xC0, 0xFC, 0x0F, 0xE0, 0x7F, 0xFF, 0xE0, 0x7F, 0x03, 0xF0, 0x3F, 0x03,  // 70
  0xFA, 0xFC, 0xFF, 0x7F, 0xFF, 0xFF, 0xEF, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x06, 0xC0, 0xFF, 0xFF, 0xFE, 0x30, 0x3F, 0xFF, 0xFF, 0xC1, 0xF8, 0x1F, 0xF0, 0x3F, 0xFF, 0xC0, 0xFF, 0x81, 0xE0, 0x7F, 0x83,  // 71
  0xFA, 0x7F, 0x7F, 0x7F, 0xFF, 0xFF, 0xEF, 0x80, 0x00, 0x07, 0xA8, 0x02, 0x78, 0x40, 0xFF, 0xFF, 0xFE, 0xF0, 0x3F, 0xFF, 0xFF, 0x81, 0xF8, 0x1F, 0xF0, 0x3F, 0xFF, 0xC0, 0xFF, 0x81, 0xE0, 0x7F, 0x81,  // 72
  0xFB, 0x3F, 0xBF, 0x3F, 0xFF, 0xFF, 0xE0, 0x01, 0xE0, 0xBF, 0xC0, 0x01, 0xC0, 0x04, 0xFF, 0xFF, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF, 0x03, 0xF8, 0x1F, 0xF0, 0x3F, 0xFF, 0xC0, 0xFF, 0x81, 0xC0, 0xFF, 0x81,  // 73
  0xFB, 0x9F, 0xDF, 0x3F, 0xFF, 0xFF, 0x80, 0x1F, 0xE3, 0xFF, 0x94, 0x01, 0x00, 0xB8, 0xFF, 0xCF, 0xFF, 0xF0, 0x7F, 0xFF, 0xFF, 0x03, 0xF0, 0x3F, 0xF0, 0x3F, 0xFF, 0x81, 0xFF, 0x81, 0xC0, 0xFF, 0x81,  // 74
  0xFB, 0xCF, 0xEF, 0x3F, 0xFF, 0xF0, 0x01, 0xF0, 0xF3, 0xF0, 0x30, 0x00, 0x07, 0x80, 0xFF, 0x9F, 0xFF, 0xF0, 0x7F, 0xFF, 0xFE, 0x07, 0xF0, 0x3F, 0xF0, 0x3F, 0xFF, 0x81, 0xFF, 0x81, 0xC0, 0xFF, 0x81,  // 75
  0xF9, 0xE7, 0xF7, 0x3F, 0xFF, 0xE4, 0x7E, 0x10, 0x71, 0x02, 0x7A, 0x00, 0xF8, 0x00, 0xFF, 0x8F, 0xFF, 0xE0, 0x7F, 0xFF, 0xFC, 0x0F, 0xF0, 0x3F, 0xF0, 0x3F, 0xFF, 0x81, 0xFF, 0x81, 0x81, 0xFF, 0x81,  // 76
  0xF8, 0xF3, 0xFB, 0xBF, 0xFF, 0x0C, 0xC2, 0x1F, 0x38, 0x70, 0x22, 0x07, 0x80, 0x3D, 0xFE, 0x03, 0xFF, 0xE0, 0x7F, 0xFF, 0xFC, 0x0F, 0xF0, 0x3F, 0xE0, 0x3F, 0xFF, 0x81, 0xFF, 0x01, 0x81, 0xFF, 0x83,  // 77
  0xF8, 0x79, 0xFD, 0xBF, 0xF0, 0x2C, 0xC3, 0xBC, 0x3B, 0xE7, 0xA0, 0x7C, 0x07, 0x7D, 0xF8, 0x03, 0xFF, 0xE0, 0x7F, 0xFF, 0xF8, 0x1F, 0xF0, 0x1F, 0xE0, 0x3F, 0xFF, 0x80, 0xFF, 0x01, 0x81, 0xFF, 0x83,  // 78
  0xF9, 0x3C, 0xFE, 0xBF, 0x03, 0xEC, 0x63, 0xF8, 0x39, 0xF2, 0x21, 0xC0, 0x3F, 0x79, 0xF8, 0xFB, 0xFF, 0xE0, 0xFF, 0xFF, 0xF0, 0x3F, 0xF8, 0x1F, 0xC0, 0x7F, 0xFF, 0xC0, 0xFE, 0x03, 0x03, 0xFF, 0x03,  // 79
  0xF9, 0x9E, 0x7F, 0x30, 0x3F, 0xED, 0x7F, 0xF8, 0xFC, 0x30, 0xF0, 0x03, 0x7F, 0x79, 0xF1, 0xFF, 0xFF, 0xE0, 0xFF, 0xFF, 0xF0, 0x3F, 0xF8, 0x06, 0x00, 0x7F, 0xFF, 0xC0, 0x30, 0x03, 0x03, 0xFF, 0x03,  // 80
  0xF9, 0xCF, 0x3F, 0x87, 0xFF, 0xED, 0x7F, 0xFF, 0xC0, 0x03, 0x00, 0x1F, 0x7F, 0x79, 0xF1, 0xFF, 0xFF, 0xC0, 0xFF, 0xFF, 0xE0, 0x7F, 0xF8, 0x00, 0x00, 0x7F, 0xFF, 0xC0, 0x00, 0x03, 0x03, 0xFF, 0x03,  // 81
  0xF9, 0xE7, 0x9F, 0xBF, 0xFF, 0xED, 0x3F, 0xFE, 0x02, 0x30, 0x00, 0x3F, 0x7E, 0x79, 0xF1, 0xFF, 0xFF, 0xC0, 0xFF, 0xFF, 0xC0, 0xFF, 0xFC, 0x00, 0x00, 0xFF, 0xFF, 0xE0, 0x00, 0x07, 0x03, 0xFF, 0x03,  // 82
  0xF9, 0xF3, 0xCF, 0xBF, 0xFF, 0xED, 0xBF, 0xC2, 0x06, 0x00, 0x00, 0x07, 0x7E, 0x79, 0xF0, 0xFF, 0xFF, 0xC0, 0xFF, 0xFF, 0xC0, 0xFF, 0xFE, 0x00, 0x40, 0xFF, 0xFF, 0xF0, 0x02, 0x07, 0x03, 0xFE, 0x07,  // 83
  0xF9, 0xF9, 0xE7, 0xBF, 0xFF, 0xED, 0x98, 0x52, 0x3E, 0x00, 0x00, 0x00, 0x7E, 0x79, 0xF8, 0x7F, 0xFF, 0xC1, 0xFF, 0xFF, 0x81, 0xFF, 0xFF, 0x80, 0xC0, 0xFF, 0xFF, 0xFC, 0x06, 0x07, 0x03, 0xFE, 0x07,  // 84
  0xF9, 0xFC, 0xF3, 0x9F, 0xFF, 0xED, 0xDB, 0x47, 0xE0, 0x00, 0x00, 0x18, 0x7E, 0x73, 0xFC, 0x1F, 0xFF, 0xC1, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0xFF, 0x81, 0xFF, 0xFF, 0xFF, 0xFC, 0x0F, 0x03, 0xFE, 0x07,  // 85
  0xF9, 0xFE, 0xF9, 0xDF, 0xFF, 0xED, 0xC8, 0x7E, 0x00, 0x00, 0x00, 0x0F, 0x7E, 0x73, 0xFE, 0x0F, 0xFF, 0x81, 0xFF, 0xFF, 0x03, 0xFF, 0xFF, 0xFF, 0x01, 0xFF, 0xFF, 0xFF, 0xF8, 0x0F, 0x03, 0xFC, 0x0F,  // 86
  0xFD, 0xFE, 0x7C, 0xDF, 0xFF, 0xED, 0xE3, 0xE0, 0x00, 0x00, 0x00, 0x03, 0x7E, 0xF3, 0xFF, 0x8F, 0xFF, 0x81, 0xFF, 0xFE, 0x07, 0xFF, 0xFF, 0xFE, 0x03, 0xFF, 0xFF, 0xFF, 0xF0, 0x1F, 0x03, 0xFC, 0x0F,  // 87
  0xFD, 0xFF, 0x3E, 0x5F, 0xFF, 0xE0, 0x78, 0x00, 0x00, 0x00, 0x3E, 0x01, 0x7C, 0xF3, 0xFF, 0xC7, 0xFF, 0x81, 0xFF, 0xFC, 0x07, 0xFF, 0xFF, 0xFC, 0x07, 0xFF, 0xFF, 0xFF, 0xE0, 0x3F, 0x03, 0xFC, 0x0F,  // 88
  0xFC, 0xFF, 0x9F, 0x18, 0x3F, 0x87, 0x0C, 0x00, 0x00, 0x03, 0xFF, 0x80, 0x79, 0xC3, 0xFF, 0xC7, 0xFF, 0x83, 0xFF, 0xFC, 0x0F, 0xFF, 0xFF, 0xF8, 0x07, 0xF8, 0x7F, 0xFF, 0xC0, 0x3F, 0x03, 0xF8, 0x1F,  // 89
  0xFC, 0xFF, 0xCF, 0x81, 0x9C, 0x0F, 0xE0, 0x00, 0x00, 0x3F, 0xFF, 0xE0, 0x63, 0x13, 0xFF, 0xC7, 0xFF, 0x83, 0xFF, 0xF8, 0x1F, 0xFF, 0xFF, 0xE0, 0x0F, 0xF0, 0x3F, 0xFF, 0x00, 0x7F, 0x01, 0xF0, 0x3F,  // 90
  0xFE, 0xFF, 0xE7, 0xDF, 0xC1, 0xEF, 0xE0, 0x00, 0x03, 0xFF, 0xF8, 0x30, 0x00, 0x73, 0xFF, 0xC7, 0xFF, 0x03, 0xFF, 0xF0, 0x1F, 0xFF, 0xFF, 0x00, 0x1F, 0xE0, 0x3F, 0xF8, 0x00, 0xFF, 0x81, 0xE0, 0x3F,  // 91
  0xFE, 0x7F, 0xF3, 0xDF, 0xDF, 0xEF, 0xE0, 0x00, 0x3F, 0xFF, 0xC0, 0x3C, 0x01, 0xF3, 0xDF, 0x8F, 0xFF, 0x03, 0xFF, 0xF0, 0x3F, 0xFF, 0xF0, 0x00, 0x3F, 0xE0, 0x3F, 0x80, 0x01, 0xFF, 0x80, 0x00, 0x7F,  // 92
  0xFF, 0x3F, 0xF9, 0xDF, 0xDF, 0xEF, 0xE0, 0x03, 0xFF, 0xFC, 0x01, 0xFF, 0x1C, 0x67, 0xC0, 0x0F, 0xFF, 0x03, 0xFF, 0xE0, 0x7F, 0xFF, 0xF0, 0x00, 0xFF, 0xE0, 0x3F, 0x80, 0x07, 0xFF, 0xC0, 0x00, 0xFF,  // 93
  0xFF, 0x3F, 0xFD, 0xDF, 0xDF, 0xEF, 0xE0, 0x1F, 0xFF, 0xF8, 0x1F, 0xE7, 0xC7, 0x27, 0xC0, 0x3F, 0xFF, 0x03, 0xFF, 0xC0, 0x7F, 0xFF, 0xF0, 0x01, 0xFF, 0xE0, 0x3F, 0x80, 0x0F, 0xFF, 0xE0, 0x01, 0xFF,  // 94
  0xFF, 0x9F, 0xFE, 0xDF, 0xDF, 0xEF, 0xE1, 0xFF, 0xFE, 0x1E, 0xFF, 0xFD, 0xE1, 0x87, 0xF8, 0xFF, 0xFF, 0x07, 0xFF, 0xC0, 0xFF, 0xFF, 0xF0, 0x0F, 0xFF, 0xF0, 0x7F, 0x80, 0x7F, 0xFF, 0xF0, 0x07, 0xFF,  // 95
  0xFF, 0x8F, 0xFE, 0xDF, 0xDF, 0xEF, 0xE7, 0xFF, 0xFC, 0x0F, 0xF7, 0xFF, 0xF8, 0xE7, 0xF9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF1, 0xFF, 0xFF, 0xF9, 0xFF, 0x8F, 0xFF, 0xFF, 0xFE, 0x3F, 0xFF,  // 96
  0xFF, 0xCF, 0xFE, 0x5F, 0xDF, 0xEF, 0xE7, 0xFF, 0xFE, 0x3F, 0x7F, 0xFF, 0xBE, 0x31, 0xF9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 97
  0xFF, 0xE7, 0xFF, 0x5F, 0xDF, 0xEF, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x08, 0xF9, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 98
  0xFF, 0xF3, 0xFF, 0x5F, 0xDF, 0xEF, 0xE7, 0xFF, 0xFF, 0xFF, 0xDF, 0xEF, 0xEF, 0xC6, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 99
  0xFF, 0xF9, 0xFF, 0x5F, 0xDF, 0xEF, 0xE7, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xF1, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 100
  0xFF, 0xFC, 0xFF, 0x5F, 0xDF, 0xEF, 0xE7, 0xFF, 0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 101
  0xFF, 0xFE, 0x7F, 0x5F, 0xDF, 0xE7, 0xE7, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xBE, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 102
  0xFF, 0xFF, 0x3F, 0x5F, 0xDF, 0xF7, 0x87, 0xFF, 0xE3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 103
  0xFF, 0xFF, 0x9F, 0x5F, 0xDF, 0xF0, 0x23, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE7, 0xC3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 104
  0xFF, 0xFF, 0x8F, 0x5F, 0xCF, 0xFD, 0xE0, 0xFF, 0xFC, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 105
  0xFF, 0xFF, 0xCF, 0x5F, 0xE7, 0xFE, 0x00, 0x7F, 0xFF, 0x9F, 0xFF, 0xFF, 0xFB, 0xFC, 0xFC, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 106
  0xFF, 0xFF, 0xE7, 0x5F, 0xF3, 0xE0, 0x34, 0x1F, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 107
  0xFF, 0xFF, 0xF3, 0x1F, 0xF8, 0x00, 0x16, 0x0F, 0xFF, 0xE3, 0xFF, 0xFD, 0xFE, 0xFF, 0xFF, 0x8F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 108
  0xFF, 0xFF, 0xF3, 0x1F, 0xFF, 0x03, 0xD7, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xF8, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 109
  0xFF, 0xFF, 0xF9, 0x1F, 0xF0, 0x3F, 0xD3, 0x80, 0xFF, 0xFC, 0xFF, 0xFF, 0x3F, 0xFF, 0xC0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 110
  0xFF, 0xFF, 0xFC, 0x1F, 0x80, 0x7F, 0x91, 0xC0, 0x7F, 0xFF, 0xFF, 0xFB, 0xFF, 0xFE, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 111
  0xFF, 0xFF, 0xFE, 0x4F, 0x30, 0xDF, 0x00, 0xE0, 0x1F, 0xFF, 0x9F, 0xFF, 0xFF, 0xF0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 112
  0xFF, 0xFF, 0xFF, 0x2F, 0x68, 0x10, 0x08, 0x70, 0x8F, 0xFF, 0xF1, 0xFF, 0xFF, 0x81, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 113
  0xFF, 0xFF, 0xFF, 0x0F, 0x40, 0x00, 0xFC, 0x38, 0x63, 0xFF, 0xE7, 0xFF, 0xFC, 0x0F, 0xCF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 114
  0xFF, 0xFF, 0xFF, 0x8F, 0x00, 0x0F, 0xFE, 0x1C, 0x01, 0xFF, 0xFF, 0xFF, 0xE0, 0xFF, 0xE7, 0xC1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 115
  0xFF, 0xFF, 0xFF, 0xC7, 0x00, 0x7F, 0xFF, 0x06, 0x2C, 0x7F, 0xFF, 0xFF, 0x07, 0xFF, 0xE3, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 116
  0xFF, 0xFF, 0xFF, 0xE0, 0x07, 0xFF, 0xFF, 0x83, 0x1C, 0x3F, 0xFF, 0xF0, 0x3F, 0xFF, 0x00, 0x3C, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 117
  0xFF, 0xFF, 0xFF, 0xF0, 0x3F, 0xFF, 0xFF, 0xC1, 0x80, 0x0F, 0xFF, 0x81, 0xFF, 0xF8, 0x60, 0xE1, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 118
  0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xE0, 0x8E, 0x03, 0xFC, 0x0F, 0xFF, 0xE3, 0x07, 0x83, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 119
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x2F, 0x01, 0xE0, 0x7F, 0xFE, 0x10, 0x3C, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 120
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x07, 0xC0, 0x03, 0xFF, 0xF8, 0xE1, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 121
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x0F, 0xC0, 0x13, 0xFF, 0xC3, 0x0F, 0x87, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 122
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x1E, 0x01, 0xF9, 0xFE, 0x00, 0x3C, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 123
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x0F, 0xFC, 0xF8, 0xC1, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 124
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x7F, 0xFE, 0x02, 0x0F, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 125
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x7C, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 126
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x83, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 127
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 128
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x3C, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 129
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0xE0, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 130
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 131
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 132
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 133
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 134
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 135
  0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 136
  0xFF, 0xFE, 0x0E, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0x8F, 0xFF, 0xFF, 0xFF, 0x83, 0xCE, 0xBF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF, 0x3F, 0x8F, 0x86, 0xBD, 0xF8, 0x60, 0xFF,  // 137
  0xFF, 0xFE, 0xF7, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0x7F, 0xFF, 0xFF, 0xDF, 0xFB, 0xB6, 0xBD, 0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xBE, 0xDF, 0xF7, 0xBE, 0xBD, 0xF7, 0xEF, 0x7F,  // 138
  0xFE, 0x3E, 0xFA, 0xE6, 0x9D, 0x0D, 0xDF, 0x4C, 0x3A, 0x70, 0xDF, 0x7D, 0x22, 0x1C, 0x0F, 0xF7, 0xB6, 0xB8, 0xC3, 0xBB, 0x9A, 0x7E, 0x98, 0x74, 0xE1, 0xBE, 0xDF, 0xF7, 0xBE, 0xBD, 0xEF, 0xEF, 0xBF,  // 139
  0xFE, 0x3E, 0xFA, 0xDE, 0x6D, 0xF6, 0xBF, 0x37, 0xD9, 0xAF, 0x5F, 0xBC, 0xDD, 0xED, 0xDF, 0xF7, 0xCF, 0xFD, 0xBD, 0xBA, 0x79, 0xBE, 0x6F, 0xB3, 0x5E, 0xBF, 0x3F, 0xCF, 0x8F, 0xFD, 0xEF, 0xEF, 0xBF,  // 140
  0xFE, 0x3E, 0xFA, 0xCE, 0xED, 0x86, 0xBF, 0x76, 0x1B, 0xA0, 0x5F, 0xDD, 0xDD, 0x0D, 0xDF, 0xEF, 0xB7, 0xFD, 0xBD, 0xBA, 0xFB, 0xBE, 0xEC, 0x37, 0x40, 0xBE, 0xB7, 0xE7, 0xF7, 0xFD, 0xEF, 0xEF, 0xBF,  // 141
  0xFF, 0xFE, 0xFA, 0xF6, 0xED, 0x76, 0xBF, 0x75, 0xDB, 0xAF, 0xDF, 0xED, 0xDC, 0xED, 0xDF, 0xEF, 0x7B, 0xFD, 0xBD, 0xBA, 0xFB, 0xBE, 0xEB, 0xB7, 0x5F, 0xBD, 0xCF, 0xF7, 0xF7, 0xFD, 0xEF, 0xEF, 0xBF,  // 142
  0xFF, 0xFE, 0xE6, 0xF6, 0xED, 0x77, 0x3F, 0x75, 0xDB, 0xB7, 0xDF, 0xED, 0xDC, 0xED, 0xDF, 0xDF, 0x7B, 0xFD, 0xB9, 0xB2, 0x7B, 0xBE, 0xEB, 0xB7, 0x6F, 0xBD, 0xCF, 0xF6, 0xF7, 0xFD, 0xF7, 0xEE, 0x7F,  // 143
  0xFF, 0xFE, 0x1E, 0xCE, 0x1D, 0x87, 0x7F, 0x0E, 0x1B, 0xB8, 0x5F, 0x1D, 0xDD, 0x0D, 0xEF, 0x9F, 0x87, 0xFE, 0xC7, 0xCB, 0x9B, 0xBE, 0x1C, 0x37, 0x70, 0xBE, 0x27, 0x0E, 0x0F, 0xFC, 0x38, 0x61, 0xFF,  // 144
  0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0x7F, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 145
  0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFE, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 146
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 147
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 148
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 149
  0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBE, 0xFF,  // 150
  0xFE, 0x1F, 0xFB, 0x7F, 0xEF, 0xFF, 0xFF, 0xBF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xE1, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFB, 0xFF, 0xFD, 0xE1, 0xFF, 0xBF, 0xBE, 0xFF,  // 151
  0xC6, 0xEF, 0xFF, 0x6F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFB, 0xEF, 0xBB, 0xFF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xDE, 0xFF, 0xFF, 0xBE, 0xFF,  // 152
  0xC6, 0xED, 0xDB, 0x47, 0xED, 0x3E, 0xED, 0xB1, 0x0D, 0x87, 0x39, 0xE1, 0xD3, 0xCB, 0xEF, 0x1A, 0x70, 0xC5, 0x38, 0x47, 0xD3, 0x84, 0x5D, 0xB0, 0xE2, 0xDB, 0x4F, 0x2F, 0xBF, 0x5D, 0xB9, 0xB6, 0xBB,  // 153
  0xC6, 0x1D, 0xDB, 0x6F, 0xEC, 0xDE, 0xCD, 0xB6, 0xF5, 0x7A, 0xF7, 0xFE, 0xCD, 0x33, 0xE1, 0xB9, 0xAF, 0x5C, 0xD7, 0xAF, 0xCD, 0x7A, 0xD9, 0xAF, 0x6E, 0xBB, 0x34, 0xCF, 0xBF, 0x5D, 0xA7, 0xAE, 0xD7,  // 154
  0xFE, 0xED, 0xDB, 0x6C, 0x6D, 0xDF, 0x4B, 0xB6, 0x05, 0x02, 0x73, 0xF0, 0xDD, 0x7B, 0xEF, 0xBB, 0xA0, 0x5D, 0xD0, 0x2F, 0xDD, 0x02, 0xE9, 0x6F, 0x6E, 0x7B, 0x75, 0xEF, 0xBF, 0x5D, 0xAF, 0x9E, 0xD7,  // 155
  0xFE, 0xED, 0xDB, 0x6F, 0xED, 0xDF, 0x2B, 0xB6, 0xFD, 0x7F, 0xBD, 0xEE, 0xDD, 0x7B, 0xEF, 0xBB, 0xAF, 0xDD, 0xD7, 0xEF, 0xDD, 0x7E, 0xE5, 0x6F, 0x6E, 0xBB, 0x75, 0xEF, 0xBF, 0x5D, 0xAF, 0xAE, 0xD7,  // 156
  0xFE, 0xED, 0x9B, 0x6F, 0xED, 0xDF, 0x33, 0xB7, 0x7D, 0xBF, 0xBD, 0xEE, 0xDD, 0x73, 0xEF, 0xBB, 0xB7, 0xDD, 0xDB, 0xEF, 0xDD, 0xBE, 0xE6, 0x6E, 0x6E, 0xDB, 0x75, 0xCF, 0xDE, 0xD9, 0xA7, 0xB6, 0xE7,  // 157
  0xFE, 0x1E, 0x5B, 0x77, 0xED, 0xDF, 0xB7, 0xB7, 0x85, 0xC2, 0x73, 0xF0, 0xDD, 0x8B, 0xE1, 0xDB, 0xB8, 0x5D, 0xDC, 0x37, 0xDD, 0xC3, 0x76, 0xF1, 0xEE, 0xCB, 0x76, 0x2F, 0xE1, 0xE5, 0xB9, 0xB2, 0xEF,  // 158
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFE, 0x7F, 0xFF, 0xFF, 0xEF,  // 159
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF,  // 160
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xBF,  // 161
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 162
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 163
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFB, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 164
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xDF, 0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xDB, 0xFF, 0xFB, 0xFF, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 165
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF7, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xEF, 0xFB, 0xFF, 0xFB, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 166
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x9C, 0x5A, 0x63, 0xC6, 0x21, 0xD2, 0x3D, 0xD8, 0x77, 0x63, 0xD2, 0x30, 0xE9, 0xDB, 0x0F, 0xCB, 0x0B, 0xB7, 0x30, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 167
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1E, 0x6D, 0xD9, 0xB7, 0xEE, 0xDE, 0xCD, 0xDE, 0xB7, 0xB7, 0x6F, 0xCD, 0xCF, 0x66, 0xDA, 0xF7, 0x32, 0xF5, 0x74, 0xEF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 168
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1E, 0xED, 0xDB, 0xB7, 0xEE, 0xDE, 0xDD, 0xDE, 0xB7, 0xB7, 0x6F, 0xDD, 0xCF, 0x6E, 0xDA, 0x07, 0x7A, 0x05, 0x75, 0xE0, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 169
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x1E, 0xED, 0xDB, 0xB7, 0xEE, 0xDE, 0xDD, 0xDE, 0xB7, 0xB7, 0x6F, 0xDD, 0xCF, 0x6E, 0xDA, 0xFF, 0x7A, 0xFD, 0x75, 0xEF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 170
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xED, 0xDB, 0xB7, 0xEE, 0xDC, 0xDD, 0xDF, 0x37, 0x36, 0x6F, 0xDD, 0xCE, 0x6E, 0xDB, 0x7F, 0x73, 0x7D, 0x74, 0xF7, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 171
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x1D, 0xDB, 0xBB, 0xEE, 0xE3, 0xDD, 0xDF, 0x78, 0xF9, 0x6F, 0xDD, 0xD1, 0xE1, 0xDB, 0x87, 0x8B, 0x86, 0xF7, 0x38, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 172
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 173
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 174
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFD, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,  // 175
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF   // 176
};

unsigned char const image_array_270_ea[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //   1
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //   2
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //   3
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //   4
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //   5
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //   6
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //   7
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //   8
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //   9
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  10
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  11
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  12
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  13
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  14
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  15
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  16
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  17
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  18
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  19
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  20
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  21
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  22
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  23
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  24
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  25
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  26
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  27
  0xff, 0xfc, 0x0f, 0xff, 0x9f, 0xff, 0xf3, 0xf3, 0xff, 0xe7, 0xf1, 0xff, 0xb3, 0xff, 0x7f, 0x9f, 0x8f, 0xc1, 0x27, 0xc0, 0xfc, 0x0f, 0xff, 0xff, 0xff, 0xf0, 0x79, 0xff, 0xff, 0x3f, 0xff, 0xff, 0xff, //  28
  0xff, 0xfc, 0x0f, 0xff, 0x9f, 0xff, 0xf3, 0xf3, 0xff, 0xe7, 0xf1, 0xff, 0x33, 0xfe, 0x7f, 0x9f, 0x07, 0xc1, 0x27, 0xc0, 0xfc, 0x07, 0xff, 0xff, 0xff, 0xf0, 0x39, 0xff, 0xff, 0x3f, 0xff, 0xff, 0xff, //  29
  0xff, 0xfc, 0xff, 0xff, 0x9f, 0xff, 0xf3, 0xf3, 0xff, 0xe7, 0xf1, 0xff, 0x3f, 0xfe, 0x7f, 0x9e, 0x67, 0xf9, 0x27, 0xcf, 0xfc, 0xe7, 0xff, 0xff, 0xff, 0xf3, 0x1f, 0xff, 0xff, 0x3f, 0xff, 0xff, 0xff, //  30
  0xff, 0xfc, 0xf8, 0x33, 0x83, 0xc7, 0x93, 0x93, 0x8f, 0x27, 0xe4, 0xe4, 0x13, 0x8c, 0x31, 0x9e, 0x67, 0xfb, 0x27, 0xcf, 0xfc, 0xe4, 0x39, 0x3c, 0x72, 0xf3, 0x99, 0xc7, 0x27, 0x30, 0xce, 0x7f, 0xff, //  31
  0xff, 0xfc, 0x08, 0x01, 0x81, 0x93, 0x03, 0x03, 0x26, 0x07, 0xe4, 0xe0, 0x13, 0x04, 0x20, 0xff, 0xe7, 0xf3, 0xff, 0xc0, 0xfc, 0xe0, 0x18, 0x19, 0x30, 0xf3, 0x99, 0x83, 0x03, 0x20, 0x4e, 0x7f, 0xff, //  32
  0xff, 0xfc, 0x09, 0x99, 0x99, 0x93, 0x33, 0x33, 0x26, 0x67, 0xe4, 0xe7, 0x33, 0x36, 0x66, 0xff, 0xcf, 0xf3, 0xff, 0xc0, 0xfc, 0x01, 0x99, 0x99, 0x33, 0xf3, 0x99, 0x9b, 0x33, 0x26, 0x64, 0xff, 0xff, //  33
  0xff, 0xfc, 0xf9, 0x99, 0x99, 0x83, 0x33, 0x33, 0x06, 0x67, 0xce, 0x67, 0x33, 0x0e, 0x61, 0xff, 0x8f, 0xf7, 0xff, 0xcf, 0x84, 0x0e, 0x19, 0x98, 0x33, 0xf3, 0x99, 0x87, 0x33, 0x38, 0x64, 0xff, 0xff, //  34
  0xff, 0xfc, 0xf9, 0x99, 0x99, 0x9f, 0x33, 0x33, 0x3e, 0x67, 0xc0, 0x67, 0x33, 0xc6, 0x78, 0xff, 0x1f, 0xe7, 0xff, 0xcf, 0x84, 0xf8, 0x19, 0x99, 0xf3, 0xf3, 0x99, 0xe3, 0x33, 0x20, 0x64, 0xff, 0xff, //  35
  0xff, 0xfc, 0xf9, 0x99, 0x99, 0x93, 0x33, 0x33, 0x26, 0x67, 0xc0, 0x67, 0x33, 0x66, 0x6c, 0xff, 0x3f, 0xe7, 0xff, 0xcf, 0xfc, 0xf9, 0x99, 0x99, 0x33, 0xf3, 0x19, 0xb3, 0x33, 0x26, 0x75, 0xff, 0xff, //  36
  0xff, 0xfc, 0x09, 0x99, 0x81, 0x93, 0x03, 0x03, 0x26, 0x07, 0x9f, 0x27, 0x13, 0x06, 0x20, 0xfe, 0x04, 0xe7, 0xff, 0xc0, 0xfc, 0xf8, 0x18, 0x19, 0x33, 0xf0, 0x39, 0x83, 0x03, 0x20, 0x71, 0xff, 0xff, //  37
  0xff, 0xfc, 0x09, 0x99, 0x93, 0xc7, 0x93, 0x93, 0x8f, 0x27, 0x9f, 0x27, 0x93, 0x8f, 0x31, 0xfe, 0x04, 0xe7, 0xff, 0xc0, 0xfc, 0xfc, 0x99, 0x3c, 0x73, 0xf0, 0x79, 0xc7, 0x27, 0x32, 0x71, 0xff, 0xff, //  38
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xff, 0xf3, 0xff, 0xff, //  39
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xff, 0xc3, 0xff, 0xff, //  40
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xff, 0xc7, 0xff, 0xff, //  41
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  42
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  43
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  44
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  45
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  46
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  47
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  48
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  49
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  50
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  51
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  52
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  53
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  54
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  55
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  56
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  57
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  58
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  59
  0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  60
  0xff, 0xff, 0xff, 0xff, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  61
  0xff, 0xff, 0xff, 0xff, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  62
  0xff, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  63
  0xff, 0xff, 0xff, 0xff, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  64
  0xff, 0xff, 0xff, 0xff, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  65
  0xff, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  66
  0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  67
  0xff, 0xff, 0xff, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  68
  0xff, 0xff, 0xff, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  69
  0xff, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  70
  0xff, 0xff, 0xff, 0xe3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  71
  0xff, 0xff, 0xff, 0xc7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  72
  0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x33, 0xc3, 0x3c, 0x0c, 0x33, 0x00, 0x03, 0xff, 0xff, //  73
  0xff, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x33, 0xc3, 0x3c, 0x0c, 0x33, 0x00, 0x03, 0xff, 0xff, //  74
  0xff, 0xff, 0xff, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0x3f, 0x33, 0x3c, 0xf3, 0x3f, 0x3f, 0xf3, 0xff, 0xff, //  75
  0xff, 0xff, 0xfe, 0x1f, 0xff, 0xc0, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0x3f, 0x33, 0x3c, 0xf3, 0x3f, 0x3f, 0xf3, 0xff, 0xff, //  76
  0xff, 0xff, 0xfe, 0x3f, 0xfc, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x03, 0x33, 0x30, 0x0c, 0x0c, 0x0f, 0x30, 0x33, 0xff, 0xff, //  77
  0xff, 0xff, 0xfc, 0x3f, 0xc0, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x03, 0x33, 0x30, 0x0c, 0x0c, 0x0f, 0x30, 0x33, 0xff, 0xff, //  78
  0xff, 0xff, 0xf8, 0x7f, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x03, 0x3f, 0x3f, 0xc0, 0x3c, 0xc3, 0x30, 0x33, 0xff, 0xff, //  79
  0xff, 0xff, 0xf8, 0x7f, 0xff, 0xc0, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x03, 0x3f, 0x3f, 0xc0, 0x3c, 0xc3, 0x30, 0x33, 0xff, 0xff, //  80
  0xff, 0xff, 0xf0, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x03, 0x33, 0xf3, 0xf3, 0x00, 0xff, 0x30, 0x33, 0xff, 0xff, //  81
  0xff, 0xff, 0xe0, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x03, 0x33, 0xf3, 0xf3, 0x00, 0xff, 0x30, 0x33, 0xff, 0xff, //  82
  0xff, 0xff, 0xe0, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0x3f, 0xfc, 0x0f, 0x30, 0xc3, 0x3f, 0xf3, 0xff, 0xff, //  83
  0xff, 0xff, 0xc1, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0x3f, 0xfc, 0x0f, 0x30, 0xc3, 0x3f, 0xf3, 0xff, 0xff, //  84
  0xff, 0xff, 0xc1, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x00, 0x03, 0xff, 0xff, //  85
  0xff, 0xff, 0x81, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x33, 0x33, 0x33, 0x33, 0x33, 0x00, 0x03, 0xff, 0xff, //  86
  0xff, 0xff, 0x83, 0xe0, 0x00, 0x00, 0x03, 0xf8, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xcf, 0xc3, 0x0f, 0xff, 0xff, 0xff, 0xff, //  87
  0xff, 0xff, 0x03, 0xe0, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xcf, 0xc3, 0x0f, 0xff, 0xff, 0xff, 0xff, //  88
  0xff, 0xff, 0x03, 0xe0, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x0f, 0xf0, 0x0f, 0xff, 0xe3, 0xff, 0xff, 0xc7, 0xf1, 0xff, 0xfc, 0x7f, 0xff, 0xff, 0xfc, 0x3f, 0xcc, 0xf3, 0xcf, 0x0f, 0x33, 0x33, 0xff, 0xff, //  89
  0xff, 0xff, 0x03, 0xe0, 0x00, 0x00, 0x00, 0x07, 0x00, 0x0f, 0xf0, 0x0f, 0xff, 0xe3, 0xff, 0xff, 0xc7, 0xf1, 0xff, 0xfc, 0x7f, 0xff, 0xff, 0xfc, 0x3f, 0xcc, 0xf3, 0xcf, 0x0f, 0x33, 0x33, 0xff, 0xff, //  90
  0xff, 0xfe, 0x03, 0xe0, 0xff, 0x80, 0x10, 0x03, 0x80, 0x07, 0xf0, 0x1f, 0xff, 0xe3, 0xff, 0xff, 0xc7, 0xf1, 0xff, 0xfc, 0x7f, 0xff, 0xf3, 0x33, 0xfc, 0xcc, 0xf3, 0x33, 0xcc, 0xc0, 0x0f, 0xff, 0xff, //  91
  0xff, 0xfe, 0x07, 0xe1, 0xff, 0xf0, 0x1e, 0x01, 0x80, 0x07, 0xf1, 0xff, 0x9c, 0xe2, 0x7c, 0x3e, 0x47, 0x91, 0xc3, 0xe4, 0x7f, 0xff, 0xf3, 0x33, 0xfc, 0xcc, 0xf3, 0x33, 0xcc, 0xc0, 0x0f, 0xff, 0xff, //  92
  0xff, 0xfc, 0x07, 0xe1, 0xff, 0xf8, 0x1f, 0x01, 0xc0, 0x07, 0xf1, 0xf8, 0x00, 0x60, 0x38, 0x1c, 0x07, 0x01, 0x81, 0xc0, 0x7f, 0xff, 0xf3, 0x0c, 0x33, 0xcf, 0x03, 0xc0, 0xfc, 0xcc, 0x0f, 0xff, 0xff, //  93
  0xff, 0xfc, 0x07, 0xe1, 0xff, 0xfc, 0x0f, 0x81, 0xc0, 0x03, 0xf0, 0x18, 0x00, 0x60, 0x10, 0x8c, 0x07, 0x01, 0x08, 0xc0, 0x7f, 0xff, 0xf3, 0x0c, 0x33, 0xcf, 0x03, 0xc0, 0xfc, 0xcc, 0x0f, 0xff, 0xff, //  94
  0xff, 0xfc, 0x07, 0xe1, 0xff, 0xfc, 0x0f, 0xc0, 0xe0, 0x03, 0xf0, 0x18, 0xc4, 0x63, 0x11, 0x88, 0x46, 0x21, 0x18, 0x84, 0x7f, 0xff, 0xfc, 0xff, 0xf0, 0xff, 0x00, 0xf3, 0x30, 0xcc, 0x03, 0xff, 0xff, //  95
  0xff, 0xf8, 0x07, 0xe1, 0xff, 0xfe, 0x0f, 0xc0, 0xe0, 0x03, 0xf0, 0x18, 0xc4, 0x63, 0x10, 0x08, 0xc6, 0x21, 0x00, 0x8c, 0x7f, 0xff, 0xfc, 0xff, 0xf0, 0xff, 0x00, 0xf3, 0x30, 0xcc, 0x03, 0xff, 0xff, //  96
  0xff, 0xf8, 0x07, 0xe1, 0xff, 0xfe, 0x0f, 0xc0, 0xf0, 0x03, 0xf0, 0xf8, 0xc4, 0x63, 0x10, 0x08, 0xc6, 0x31, 0x00, 0x8c, 0x7f, 0xff, 0xf3, 0xf3, 0x30, 0x33, 0x30, 0xcc, 0x33, 0x0c, 0xf3, 0xff, 0xff, //  97
  0xff, 0xf8, 0x07, 0xe1, 0xff, 0xfe, 0x0f, 0xc0, 0xf0, 0x03, 0xf1, 0xf8, 0xc4, 0x63, 0x10, 0xf8, 0xc6, 0x31, 0x1f, 0x8c, 0x7f, 0xff, 0xf3, 0xf3, 0x30, 0x33, 0x30, 0xcc, 0x33, 0x0c, 0xf3, 0xff, 0xff, //  98
  0xff, 0xf8, 0x07, 0xe1, 0xff, 0xfc, 0x00, 0x00, 0xf0, 0x03, 0xf1, 0xf8, 0xc4, 0x63, 0x11, 0xf8, 0xc6, 0x31, 0x1f, 0x8c, 0x7f, 0xff, 0xf0, 0x3c, 0xff, 0xfc, 0xc3, 0x00, 0x0f, 0x0c, 0xf3, 0xff, 0xff, //  99
  0xff, 0xf8, 0x07, 0xe1, 0xff, 0xf8, 0x00, 0x00, 0xf0, 0x03, 0xf0, 0x38, 0xc4, 0x63, 0x11, 0x88, 0x46, 0x21, 0x18, 0x84, 0x7f, 0xff, 0xf0, 0x3c, 0xff, 0xfc, 0xc3, 0x00, 0x0f, 0x0c, 0xf3, 0xff, 0xff, // 100
  0xff, 0xf0, 0x07, 0xe1, 0xff, 0xf0, 0x00, 0x00, 0xf8, 0x03, 0xf0, 0x08, 0xc4, 0x60, 0x30, 0x0c, 0x07, 0x01, 0x00, 0xc0, 0x7f, 0xff, 0xff, 0x30, 0x3f, 0xf3, 0x00, 0xc3, 0x33, 0xf3, 0xcf, 0xff, 0xff, // 101
  0xff, 0xf0, 0x07, 0xe1, 0xff, 0xc0, 0x00, 0x00, 0xf8, 0x03, 0xf0, 0x08, 0xc4, 0x60, 0x38, 0x1c, 0x07, 0x01, 0x81, 0xc0, 0x7f, 0xff, 0xff, 0x30, 0x3f, 0xf3, 0x00, 0xc3, 0x33, 0xf3, 0xcf, 0xff, 0xff, // 102
  0xff, 0xf0, 0x07, 0xe1, 0xfe, 0x00, 0x1f, 0xe0, 0xf8, 0x03, 0xff, 0xff, 0xff, 0xfe, 0x7c, 0x3e, 0x7f, 0x9f, 0xc3, 0xe7, 0xff, 0xff, 0xfc, 0xff, 0xcc, 0xf3, 0x30, 0xf3, 0xc3, 0xcc, 0x0f, 0xff, 0xff, // 103
  0xff, 0xf0, 0x07, 0xe0, 0x00, 0x00, 0xff, 0xe0, 0xf8, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xcc, 0xf3, 0x30, 0xf3, 0xc3, 0xcc, 0x0f, 0xff, 0xff, // 104
  0xff, 0xf0, 0x03, 0xe0, 0x00, 0x03, 0xff, 0xe0, 0xf8, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x00, 0x3f, 0x0c, 0x0c, 0x33, 0x30, 0xf3, 0xc3, 0xff, 0xff, // 105
  0xff, 0xf0, 0x03, 0xe0, 0x00, 0x07, 0xff, 0xe0, 0xf8, 0x03, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xff, 0xe3, 0x8f, 0xfc, 0x7f, 0xff, 0xff, 0xf3, 0x00, 0x3f, 0x0c, 0x0c, 0x33, 0x30, 0xf3, 0xc3, 0xff, 0xff, // 106
  0xff, 0xf0, 0x03, 0xe0, 0x00, 0x0f, 0xff, 0xe0, 0xf8, 0x03, 0xff, 0xff, 0xff, 0xff, 0xe0, 0xff, 0xc7, 0x1f, 0xfc, 0x7f, 0xff, 0xff, 0xff, 0xf3, 0xff, 0x30, 0x0f, 0xff, 0x00, 0x0f, 0xf3, 0xff, 0xff, // 107
  0xff, 0xf0, 0x03, 0xe0, 0xfc, 0x0f, 0xff, 0xe0, 0xf8, 0x07, 0xff, 0xff, 0xff, 0xff, 0xe0, 0xff, 0xc7, 0xff, 0xfc, 0x7f, 0xff, 0xff, 0xff, 0xf3, 0xff, 0x30, 0x0f, 0xff, 0x00, 0x0f, 0xf3, 0xff, 0xff, // 108
  0xff, 0xf0, 0x01, 0xe0, 0xfc, 0x0f, 0xff, 0xe0, 0xf8, 0x07, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xe2, 0x03, 0x1c, 0x18, 0x30, 0x7f, 0xff, 0xff, 0x0f, 0x33, 0xf3, 0xff, 0x00, 0xc3, 0xf0, 0x03, 0xff, 0xff, // 109
  0xff, 0xf0, 0x01, 0xe0, 0xfc, 0x1f, 0xff, 0xe0, 0xf8, 0x07, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xe0, 0x03, 0x18, 0x10, 0x20, 0x3f, 0xff, 0xff, 0x0f, 0x33, 0xf3, 0xff, 0x00, 0xc3, 0xf0, 0x03, 0xff, 0xff, // 110
  0xff, 0xf0, 0x01, 0xe0, 0xfc, 0x0f, 0xff, 0xe0, 0xf8, 0x07, 0xff, 0xff, 0xff, 0xff, 0xc8, 0xe0, 0x87, 0x11, 0x98, 0x66, 0x3f, 0xff, 0xf0, 0x3c, 0xf3, 0x33, 0xc0, 0xc3, 0xc0, 0xfc, 0x03, 0xff, 0xff, // 111
  0xff, 0xf8, 0x00, 0xe0, 0x7c, 0x0f, 0xff, 0xe0, 0xf8, 0x0f, 0xff, 0xff, 0xff, 0xff, 0x88, 0xe3, 0x8e, 0x31, 0xb8, 0xc7, 0x7f, 0xff, 0xf0, 0x3c, 0xf3, 0x33, 0xc0, 0xc3, 0xc0, 0xfc, 0x03, 0xff, 0xff, // 112
  0xff, 0xf8, 0x00, 0xe0, 0x3e, 0x07, 0xff, 0xe0, 0xf8, 0x0f, 0xff, 0xff, 0xff, 0xff, 0x88, 0xc7, 0x8e, 0x30, 0x78, 0xc1, 0xff, 0xff, 0xff, 0x30, 0x30, 0xc3, 0xf3, 0x33, 0x03, 0xc0, 0xff, 0xff, 0xff, // 113
  0xff, 0xf8, 0x00, 0x70, 0x1e, 0x03, 0xff, 0xe0, 0xf8, 0x0f, 0xff, 0xff, 0xff, 0xff, 0x08, 0xc7, 0x8e, 0x30, 0x38, 0xe0, 0x7f, 0xff, 0xff, 0x30, 0x30, 0xc3, 0xf3, 0x33, 0x03, 0xc0, 0xff, 0xff, 0xff, // 114
  0xff, 0xf8, 0x00, 0x30, 0x03, 0x00, 0x7f, 0xe0, 0xf8, 0x1f, 0xff, 0xff, 0xff, 0xff, 0x00, 0xc7, 0x8e, 0x3c, 0x10, 0xf0, 0x7f, 0xff, 0xf0, 0x30, 0xcc, 0xcf, 0xf3, 0xc3, 0x33, 0xc0, 0x3f, 0xff, 0xff, // 115
  0xff, 0xfc, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x1f, 0xff, 0xff, 0xff, 0xff, 0x00, 0xc7, 0x8e, 0x3e, 0x11, 0xfc, 0x7f, 0xff, 0xf0, 0x30, 0xcc, 0xcf, 0xf3, 0xc3, 0x33, 0xc0, 0x3f, 0xff, 0xff, // 116
  0xff, 0xfc, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x3f, 0xff, 0xff, 0xff, 0xfe, 0x38, 0xc7, 0x0c, 0x63, 0x31, 0x8c, 0x7f, 0xff, 0xf3, 0x33, 0x3c, 0xf3, 0x0c, 0x3c, 0x3f, 0xc0, 0xcf, 0xff, 0xff, // 117
  0xff, 0xfe, 0x00, 0x0f, 0x80, 0x00, 0x00, 0x00, 0xf0, 0x3f, 0xff, 0xff, 0xff, 0xfe, 0x38, 0x8f, 0x04, 0x60, 0x30, 0x80, 0x7f, 0xff, 0xf3, 0x33, 0x3c, 0xf3, 0x0c, 0x3c, 0x3f, 0xc0, 0xcf, 0xff, 0xff, // 118
  0xff, 0xfe, 0x00, 0x07, 0xf0, 0x00, 0x00, 0x01, 0xf0, 0x7f, 0xff, 0xff, 0xff, 0xfc, 0x38, 0x8f, 0x8c, 0x60, 0x70, 0xc0, 0xff, 0xff, 0xf3, 0xff, 0xcf, 0x0c, 0xc3, 0xf3, 0xcf, 0xc3, 0x3f, 0xff, 0xff, // 119
  0xff, 0xff, 0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xcf, 0x0c, 0xc3, 0xf3, 0xcf, 0xc3, 0x3f, 0xff, 0xff, // 120
  0xff, 0xff, 0x80, 0x00, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xc0, 0x0c, 0xcf, 0xcc, 0x33, 0xf0, 0x00, 0xf3, 0xff, 0xff, // 121
  0xff, 0xff, 0x80, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xc0, 0x0c, 0xcf, 0xcc, 0x33, 0xf0, 0x00, 0xf3, 0xff, 0xff, // 122
  0xff, 0xff, 0xc0, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xe1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xc0, 0x33, 0x00, 0x33, 0xf0, 0x03, 0xff, 0xff, // 123
  0xff, 0xff, 0xe0, 0x00, 0x01, 0xff, 0xff, 0xff, 0xc1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xc0, 0x33, 0x00, 0x33, 0xf0, 0x03, 0xff, 0xff, // 124
  0xff, 0xff, 0xf0, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xc3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x3c, 0x30, 0xc0, 0xff, 0x03, 0x33, 0x0f, 0xff, 0xff, // 125
  0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0xff, 0xff, 0x83, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x3c, 0x30, 0xc0, 0xff, 0x03, 0x33, 0x0f, 0xff, 0xff, // 126
  0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x87, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0x30, 0x33, 0xcc, 0x0c, 0x03, 0xf0, 0x0f, 0xff, 0xff, // 127
  0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x7f, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0x30, 0x33, 0xcc, 0x0c, 0x03, 0xf0, 0x0f, 0xff, 0xff, // 128
  0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x07, 0xff, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x03, 0x3c, 0x00, 0xff, 0xfc, 0x30, 0x03, 0xcf, 0xff, 0xff, // 129
  0xff, 0xff, 0xff, 0xfe, 0x00, 0x00, 0xff, 0xff, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x03, 0x3c, 0x00, 0xff, 0xfc, 0x30, 0x03, 0xcf, 0xff, 0xff, // 130
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x03, 0x3f, 0xcf, 0x03, 0xc0, 0xf3, 0xc3, 0x0f, 0xff, 0xff, // 131
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x03, 0x3f, 0xcf, 0x03, 0xc0, 0xf3, 0xc3, 0x0f, 0xff, 0xff, // 132
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x03, 0x3c, 0xcc, 0xcc, 0x30, 0xf3, 0xf3, 0xc3, 0xff, 0xff, // 133
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x03, 0x3c, 0xcc, 0xcc, 0x30, 0xf3, 0xf3, 0xc3, 0xff, 0xff, // 134
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0x3c, 0xfc, 0xc0, 0xcf, 0x3c, 0x3c, 0x3f, 0xff, 0xff, // 135
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0x3c, 0xfc, 0xc0, 0xcf, 0x3c, 0x3c, 0x3f, 0xff, 0xff, // 136
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x3f, 0xc3, 0x03, 0x3c, 0x00, 0xff, 0xcf, 0xff, 0xff, // 137
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x3f, 0xc3, 0x03, 0x3c, 0x00, 0xff, 0xcf, 0xff, 0xff, // 138
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 139
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 140
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 141
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 142
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 143
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 144
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 145
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 146
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 147
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 148
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 149
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 150
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 151
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 152
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 153
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 154
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 155
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 156
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 157
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 158
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 159
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 160
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 161
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 162
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 163
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 164
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 165
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 166
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 167
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 168
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 169
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 170
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 171
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 172
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 173
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 174
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 175
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 176
};

unsigned char const image_array_270_text[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //   1
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //   2
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //   3
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //   4
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //   5
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //   6
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //   7
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //   8
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //   9
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  10
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  11
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  12
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  13
  0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  14
  0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  15
  0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  16
  0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  17
  0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  18
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, //  19
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xcf, 0xe7, 0x03, 0x03, 0xff, 0xff, //  20
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xfe, 0x00, 0x0f, 0x33, 0x33, 0xff, 0xff, //  21
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xfe, 0x7f, 0x03, 0x03, 0xff, 0xff, //  22
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0x32, 0x7f, 0x33, 0x33, 0xff, 0xff, //  23
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0x86, 0x7f, 0x03, 0x03, 0xff, 0xff, //  24
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xfc, 0x00, 0x03, 0x3f, 0xf3, 0xff, 0xff, //  25
  0xf8, 0x3e, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9f, 0xff, 0xfe, 0x7f, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xce, 0x4f, 0x20, 0x13, 0xff, 0xff, //  26
  0xf8, 0x3c, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9f, 0xff, 0xfe, 0x7f, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xce, 0x4f, 0x33, 0x33, 0xff, 0xff, //  27
  0xf8, 0x38, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9f, 0xff, 0xfe, 0x7f, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xfe, 0x00, 0x4f, 0x30, 0x33, 0xff, 0xff, //  28
  0xf8, 0x39, 0xff, 0xc3, 0xf2, 0x38, 0x7c, 0x87, 0x9f, 0x07, 0xfc, 0x0f, 0x07, 0x1e, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xce, 0x4f, 0x33, 0x33, 0xff, 0xff, //  29
  0xf8, 0x39, 0xff, 0x81, 0xf0, 0x10, 0x7c, 0x03, 0x9c, 0x03, 0xfc, 0x0c, 0x03, 0x9e, 0x60, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0x02, 0x4f, 0x30, 0x33, 0xff, 0xff, //  30
  0xf8, 0x3c, 0x1f, 0xb8, 0xf1, 0x86, 0x3c, 0x71, 0x9c, 0xf1, 0xfe, 0x7c, 0xf1, 0xcc, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xfe, 0x48, 0x4f, 0x33, 0x03, 0xff, 0xff, //  31
  0xf8, 0x3e, 0x07, 0xfc, 0xf3, 0xcf, 0x3c, 0xf9, 0x99, 0xf9, 0xfe, 0x79, 0xf9, 0xcc, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xfc, 0xcc, 0xcf, 0x00, 0x33, 0xff, 0xff, //  32
  0xf8, 0x3f, 0xe3, 0xc0, 0xf3, 0xcf, 0x3c, 0xf9, 0x98, 0x01, 0xfe, 0x78, 0x01, 0xe1, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0x0c, 0xcf, 0x3f, 0x03, 0xff, 0xff, //  33
  0xf8, 0x3f, 0xf3, 0x00, 0xf3, 0xcf, 0x3c, 0xf9, 0x98, 0x01, 0xfe, 0x78, 0x01, 0xe1, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0x99, 0xcf, 0x3f, 0x27, 0xff, 0xff, //  34
  0xf8, 0x3f, 0xf3, 0x3c, 0xf3, 0xcf, 0x3c, 0xf9, 0x99, 0xff, 0xfe, 0x79, 0xff, 0xcc, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  35
  0xf8, 0x3b, 0xe3, 0x38, 0xf3, 0xcf, 0x3c, 0x71, 0x9c, 0xfd, 0xfe, 0x7c, 0xfd, 0xcc, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  36
  0xf8, 0x38, 0x07, 0x00, 0xf3, 0xcf, 0x3c, 0x03, 0x9c, 0x01, 0xfe, 0x0c, 0x01, 0x9e, 0x70, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0x9f, 0xff, 0xe7, 0xff, 0xff, 0xff, //  37
  0xf8, 0x3c, 0x0f, 0x84, 0xf3, 0xcf, 0x3c, 0x87, 0x9f, 0x03, 0xff, 0x0f, 0x03, 0x1e, 0x38, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0x9f, 0xff, 0xc0, 0x1f, 0xff, 0xff, //  38
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0x00, 0x07, 0x9f, 0x9f, 0xff, 0xff, //  39
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0x3f, 0xff, 0x00, 0x07, 0xff, 0xff, //  40
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xfe, 0x40, 0x1e, 0x1c, 0xe7, 0xff, 0xff, //  41
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xfc, 0xff, 0xff, 0x99, 0xe7, 0xff, 0xff, //  42
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0x00, 0x1f, 0x80, 0x07, 0xff, 0xff, //  43
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xe7, 0x9f, 0xf1, 0xff, 0xff, 0xff, //  44
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0x24, 0x9f, 0xc4, 0xcf, 0xff, 0xff, //  45
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0x81, 0x9f, 0x18, 0x1f, 0xff, 0xff, //  46
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xff, 0xff, 0x39, 0xff, 0xff, 0xf9, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xfe, 0x00, 0x1f, 0xe2, 0x3f, 0xff, 0xff, //  47
  0xf8, 0x3f, 0x03, 0xff, 0xff, 0xf9, 0xf3, 0xff, 0xff, 0xff, 0x00, 0xff, 0xcf, 0xff, 0xcf, 0xff, 0xff, 0x39, 0xff, 0xff, 0xf9, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xc3, 0x9f, 0x0c, 0x1f, 0xff, 0xff, //  48
  0xf8, 0x3e, 0x01, 0xff, 0xff, 0xf9, 0xf3, 0xff, 0xff, 0xff, 0x00, 0xff, 0xcf, 0xff, 0xcf, 0xff, 0xff, 0x3f, 0xff, 0xff, 0xf9, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0x81, 0xc3, 0xf0, 0x4f, 0xff, 0xff, //  49
  0xf8, 0x3c, 0x78, 0xff, 0xff, 0xf9, 0xf3, 0xff, 0xff, 0xff, 0x3f, 0xff, 0xcf, 0xff, 0xcf, 0xff, 0xff, 0x3f, 0xff, 0xff, 0xf9, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0x24, 0xc3, 0xc6, 0x67, 0xff, 0xff, //  50
  0xf8, 0x3c, 0xfc, 0xf2, 0x1f, 0xf0, 0x32, 0x1f, 0x83, 0xff, 0x3f, 0xff, 0xce, 0x43, 0xcf, 0x3f, 0xe1, 0x39, 0xc1, 0xc8, 0x79, 0xe1, 0xe7, 0xe4, 0x1f, 0xff, 0xfe, 0x66, 0x62, 0x18, 0x71, 0xff, 0xff, //  51
  0xf8, 0x39, 0xfe, 0x70, 0x1f, 0xf0, 0x30, 0x1e, 0x01, 0xff, 0x3f, 0xff, 0xce, 0x03, 0xce, 0x7f, 0xc0, 0x39, 0x80, 0xc0, 0x39, 0xc0, 0xe7, 0xe4, 0x1f, 0xff, 0xff, 0xe7, 0xf3, 0xfc, 0xff, 0xff, 0xff, //  52
  0xf8, 0x39, 0xfe, 0x71, 0x8f, 0xf9, 0xf1, 0x8e, 0x78, 0xff, 0x00, 0xff, 0xce, 0x31, 0xcc, 0xff, 0x8e, 0x39, 0x9e, 0xc7, 0x19, 0xdc, 0x73, 0xcc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  53
  0xf8, 0x39, 0xfe, 0x73, 0xcf, 0xf9, 0xf3, 0xcc, 0xfc, 0xff, 0x00, 0xff, 0xce, 0x79, 0xc9, 0xff, 0x9f, 0x39, 0x8f, 0xcf, 0x99, 0xfe, 0x73, 0xcc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  54
  0xf8, 0x39, 0xfe, 0x73, 0xcf, 0xf9, 0xf3, 0xcc, 0x00, 0xff, 0x3f, 0xc1, 0xce, 0x79, 0xc3, 0xff, 0x9f, 0x39, 0xc1, 0xcf, 0x99, 0xe0, 0x79, 0x9c, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  55
  0xf8, 0x39, 0xfe, 0x73, 0xcf, 0xf9, 0xf3, 0xcc, 0x00, 0xff, 0x3f, 0xc1, 0xce, 0x79, 0xc3, 0xff, 0x9f, 0x39, 0xf0, 0xcf, 0x99, 0x80, 0x79, 0x9c, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  56
  0xf8, 0x3c, 0xfc, 0xf3, 0xcf, 0xf9, 0xf3, 0xcc, 0xff, 0xff, 0x3f, 0xff, 0xce, 0x79, 0xc9, 0xff, 0x9f, 0x39, 0xfc, 0xcf, 0x99, 0x9e, 0x7c, 0x3c, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  57
  0xf8, 0x3c, 0x78, 0xf3, 0xcf, 0xf9, 0xf3, 0xce, 0x7e, 0xff, 0x3f, 0xff, 0xce, 0x79, 0xcc, 0xff, 0x8e, 0x39, 0xbc, 0xc7, 0x19, 0x9c, 0x7c, 0x3c, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  58
  0xf8, 0x3e, 0x01, 0xf3, 0xcf, 0xf8, 0x33, 0xce, 0x00, 0xff, 0x00, 0xff, 0xce, 0x79, 0xce, 0x7f, 0xc0, 0x39, 0x80, 0xc0, 0x39, 0x80, 0x7e, 0x7c, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  59
  0xf8, 0x3f, 0x03, 0xf3, 0xcf, 0xfc, 0x33, 0xcf, 0x81, 0xff, 0x00, 0xff, 0xce, 0x79, 0xcf, 0x3f, 0xe1, 0x39, 0xc3, 0xc8, 0x79, 0xc2, 0x7e, 0x7c, 0x1f, 0xff, 0xff, 0xf0, 0x00, 0x01, 0xff, 0xff, 0xff, //  60
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xff, 0xff, 0xfe, 0x7c, 0x1f, 0xff, 0xff, 0xf0, 0x00, 0x03, 0xff, 0xff, 0xff, //  61
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xff, 0xff, 0xfc, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xff, 0xff, //  62
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xff, 0xff, 0xf0, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xff, 0xff, //  63
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xff, 0xff, 0xf1, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xff, 0xff, //  64
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xff, 0xff, //  65
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xff, 0xff, //  66
  0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xe0, 0x00, 0x00, 0xff, 0xff, 0xff, //  67
  0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xe0, 0x00, 0x00, 0xff, 0xff, 0xff, //  68
  0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xf1, 0xff, 0xff, 0xff, 0xff, //  69
  0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xf1, 0xff, 0xff, 0xff, 0xff, //  70
  0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xf1, 0xff, 0xff, 0xff, 0xff, //  71
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0xff, 0xff, 0xff, 0xff, //  72
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x7f, 0xff, 0xff, 0xff, //  73
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0x3f, 0xff, 0xff, 0xff, //  74
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x8f, 0x1f, 0xff, 0xff, 0xff, //  75
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1f, 0x8f, 0xff, 0xff, 0xff, //  76
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x3f, 0xc7, 0xff, 0xff, 0xff, //  77
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x7f, 0xe1, 0xff, 0xff, 0xff, //  78
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0xff, 0xf0, 0xff, 0xff, 0xff, //  79
  0xff, 0xfc, 0x1f, 0xc7, 0xe0, 0xfc, 0x0f, 0xf8, 0xf0, 0x3f, 0x87, 0x80, 0x7c, 0x1f, 0x87, 0xfc, 0xfe, 0x07, 0xfc, 0x0f, 0xff, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe3, 0xff, 0xfc, 0xff, 0xff, 0xff, //  80
  0xff, 0xf8, 0x0f, 0x07, 0xc0, 0x78, 0x07, 0xf8, 0xf0, 0x3f, 0x03, 0x80, 0x78, 0x0f, 0x01, 0xfc, 0xfe, 0x01, 0xf0, 0x07, 0xff, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  81
  0xff, 0xf9, 0xcf, 0x27, 0xde, 0x3b, 0xe3, 0xf4, 0xf3, 0xfe, 0x3b, 0xfc, 0xf1, 0xc6, 0x39, 0xf8, 0x7e, 0x79, 0xe3, 0xf7, 0xff, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  82
  0xff, 0xf3, 0xe7, 0xe7, 0xff, 0x3f, 0xf3, 0xe4, 0xf3, 0xfc, 0x7f, 0xfc, 0xf3, 0xe6, 0x7c, 0xf8, 0x7e, 0x79, 0xe7, 0xff, 0x87, 0xe4, 0x3f, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  83
  0xff, 0xf3, 0xe7, 0xe7, 0xff, 0x3f, 0xe3, 0xec, 0xf0, 0x7c, 0xff, 0xfc, 0xf1, 0xc6, 0x7c, 0xf3, 0x3e, 0x79, 0xcf, 0xff, 0x03, 0xe0, 0x1c, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  84
  0xff, 0xf3, 0xe7, 0xe7, 0xfe, 0x3e, 0x0f, 0xdc, 0xf0, 0x3c, 0x87, 0xf8, 0xfc, 0x1e, 0x38, 0xf3, 0x3e, 0x03, 0xcf, 0xff, 0x71, 0xe3, 0x8c, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  85
  0xff, 0xf3, 0xe7, 0xe7, 0xfe, 0x7e, 0x07, 0x9c, 0xf7, 0x1c, 0x03, 0xf9, 0xf8, 0x0f, 0x00, 0xf3, 0x3e, 0x03, 0xcf, 0xff, 0xf9, 0xe7, 0xc9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  86
  0xff, 0xf3, 0xe7, 0xe7, 0xfc, 0xff, 0xe3, 0xbc, 0xff, 0x9c, 0x71, 0xf9, 0xf1, 0xc7, 0x84, 0xe7, 0x9e, 0x79, 0xcf, 0xff, 0x81, 0xe7, 0xc9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  87
  0xff, 0xf3, 0xe7, 0xe7, 0xf9, 0xff, 0xf3, 0x00, 0x3f, 0x9c, 0xf9, 0xf1, 0xf3, 0xe7, 0xfc, 0xe0, 0x1e, 0x7c, 0xcf, 0xfe, 0x01, 0xe7, 0xc9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //  88
  0xff, 0xf3, 0xe7, 0xe7, 0xf3, 0xff, 0xf3, 0x00, 0x3f, 0x9c, 0xf9, 0xf3, 0xf3, 0xe7, 0xf8, 0xc0, 0x0e, 0x7c, 0xe7, 0xfe, 0x79, 0xe7, 0xc9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xff, //  89
  0xff, 0xf9, 0xcf, 0xe7, 0xe7, 0xfb, 0xe3, 0xfc, 0xef, 0x1e, 0x71, 0xf3, 0xf1, 0xc7, 0x71, 0xcf, 0xce, 0x78, 0xe3, 0xf6, 0x71, 0xe3, 0x8c, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xe3, 0xff, 0xff, 0xff, 0xff, //  90
  0xff, 0xf8, 0x0f, 0x00, 0xc0, 0x38, 0x07, 0xfc, 0xe0, 0x3e, 0x03, 0xe3, 0xf8, 0x0f, 0x03, 0xcf, 0xce, 0x01, 0xf0, 0x06, 0x01, 0xe0, 0x1c, 0x07, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xff, 0xff, //  91
  0xff, 0xfc, 0x1f, 0x00, 0xc0, 0x3c, 0x0f, 0xfc, 0xf0, 0x7f, 0x87, 0xe7, 0xfc, 0x1f, 0x87, 0x9f, 0xe6, 0x03, 0xfc, 0x0f, 0x09, 0xe4, 0x3f, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xf1, 0xff, 0xff, 0xff, 0xff, //  92
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00, 0xff, 0xff, 0xff, //  93
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00, 0xff, 0xff, 0xff, //  94
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x7f, 0xcf, 0xff, 0xff, 0xff, //  95
  0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xfe, 0x7f, 0xcf, 0xff, 0xff, 0xff, //  96
  0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xfe, 0x7f, 0xcf, 0xff, 0xff, 0xff, //  97
  0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0x3f, 0x9f, 0xff, 0xff, 0xff, //  98
  0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0x3f, 0x9f, 0xff, 0xff, 0xff, //  99
  0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0x9f, 0x3f, 0xff, 0xff, 0xff, // 100
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0x8e, 0x3f, 0xff, 0xff, 0xff, // 101
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xc4, 0x7f, 0xff, 0xff, 0xff, // 102
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xe0, 0xff, 0xff, 0xff, 0xff, // 103
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xf0, 0xff, 0xff, 0xff, 0xff, // 104
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xc0, 0x7f, 0xff, 0xff, 0xff, // 105
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0x84, 0x3f, 0xff, 0xff, 0xff, // 106
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xfe, 0x1e, 0x0f, 0xff, 0xff, 0xff, // 107
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xf8, 0x3f, 0x83, 0xff, 0xff, 0xff, // 108
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xc0, 0xff, 0xe0, 0xff, 0xff, 0xff, // 109
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xe7, 0xff, 0xf8, 0xff, 0xff, 0xff, // 110
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 111
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 112
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 113
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 114
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 115
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 116
  0xf8, 0x3f, 0xff, 0xf0, 0x3f, 0xff, 0xff, 0xf1, 0xe3, 0xbf, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 117
  0xf8, 0x3f, 0xff, 0xe3, 0x8f, 0xff, 0xff, 0xf1, 0xe3, 0xff, 0xc7, 0xef, 0xff, 0xff, 0xfc, 0x7f, 0xde, 0x3d, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 118
  0xf8, 0x3f, 0xff, 0xc7, 0xcf, 0xff, 0xff, 0xf1, 0xe3, 0xff, 0xc7, 0xef, 0xff, 0xff, 0xfc, 0x7f, 0xde, 0x3d, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xfc, 0xcf, 0xff, 0xff, 0xff, 0xff, // 119
  0xf8, 0x3f, 0xff, 0xc7, 0xef, 0xff, 0xff, 0xff, 0xe3, 0xff, 0xc7, 0xff, 0xff, 0xff, 0xfc, 0x7f, 0xfe, 0x3f, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xe0, 0x01, 0x00, 0xff, 0xff, 0xff, // 120
  0xf8, 0x3f, 0xff, 0xc3, 0xff, 0x81, 0xc2, 0x01, 0xc0, 0xff, 0xc7, 0xbc, 0x0f, 0x08, 0x78, 0x1f, 0xfe, 0x3f, 0x03, 0x02, 0x10, 0x3f, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xe0, 0x01, 0x3c, 0xff, 0xff, 0xff, // 121
  0xf8, 0x3f, 0xff, 0xc0, 0x3f, 0x18, 0xe1, 0xd1, 0xe3, 0xff, 0xc7, 0xb8, 0xc7, 0x86, 0x3c, 0x7f, 0xfe, 0x3e, 0x31, 0xc7, 0x78, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xfc, 0xcf, 0x3c, 0xff, 0xff, 0xff, // 122
  0xf8, 0x3f, 0xff, 0xe0, 0x0e, 0x3c, 0xe3, 0xf1, 0xe3, 0xff, 0xc0, 0x31, 0xe3, 0x8e, 0x3c, 0x7f, 0xfe, 0x3c, 0x79, 0xc2, 0xf8, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xf0, 0xc3, 0x3c, 0xff, 0xff, 0xff, // 123
  0xf8, 0x3f, 0xff, 0xf8, 0x06, 0x3c, 0x63, 0xf1, 0xe3, 0xff, 0xc7, 0xb1, 0xe3, 0x8e, 0x3c, 0x7f, 0xfe, 0x3c, 0x78, 0xe1, 0xf8, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xe0, 0x41, 0x00, 0xff, 0xff, 0xff, // 124
  0xf8, 0x3f, 0xff, 0xff, 0x86, 0x00, 0x63, 0xf1, 0xe3, 0xff, 0xc7, 0xb1, 0xe3, 0x8e, 0x3c, 0x7f, 0xfe, 0x3c, 0x00, 0xf1, 0xf8, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xe6, 0x59, 0x3c, 0xff, 0xff, 0xff, // 125
  0xf8, 0x3f, 0xff, 0xdf, 0xc6, 0x3f, 0xe3, 0xf1, 0xe3, 0xff, 0xc7, 0xf1, 0xe3, 0x8e, 0x3c, 0x7f, 0xfe, 0x3c, 0x7f, 0xe0, 0xf8, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xe0, 0x41, 0x3c, 0xff, 0xff, 0xff, // 126
  0xf8, 0x3f, 0xff, 0xcf, 0xc6, 0x3f, 0x63, 0xf1, 0xe3, 0xff, 0xc7, 0xf1, 0xe3, 0x8e, 0x3c, 0x6f, 0xfe, 0x3c, 0x7e, 0xc8, 0x78, 0xdf, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xe0, 0x41, 0x3c, 0xff, 0xff, 0xff, // 127
  0xf8, 0x3f, 0xff, 0xc7, 0x8f, 0x1e, 0xe3, 0xf1, 0xe3, 0xff, 0xc7, 0xf8, 0xc7, 0x8e, 0x3c, 0x6f, 0xfe, 0x3e, 0x3d, 0xdc, 0x78, 0xdf, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xfb, 0xff, 0x00, 0xff, 0xff, 0xff, // 128
  0xf8, 0x3f, 0xff, 0xf0, 0x1f, 0x81, 0xc1, 0xe0, 0xc0, 0xff, 0x01, 0xfc, 0x0f, 0x04, 0x1e, 0x1f, 0xf8, 0x0f, 0x03, 0x08, 0x1c, 0x3f, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xf9, 0xbf, 0x3c, 0xff, 0xff, 0xff, // 129
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xf0, 0x01, 0x3c, 0xff, 0xff, 0xff, // 130
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xf0, 0x01, 0x3c, 0xff, 0xff, 0xff, // 131
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xe3, 0x9f, 0x00, 0xff, 0xff, 0xff, // 132
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xc0, 0x01, 0x01, 0xff, 0xff, 0xff, // 133
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xd0, 0x03, 0xd3, 0xff, 0xff, 0xff, // 134
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xf3, 0x9f, 0x93, 0xff, 0xff, 0xff, // 135
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xf0, 0x01, 0x93, 0xff, 0xff, 0xff, // 136
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xf3, 0x9f, 0x92, 0x7f, 0xff, 0xff, // 137
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xf3, 0x9f, 0x32, 0x7f, 0xff, 0xff, // 138
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xf0, 0x00, 0x30, 0x7f, 0xff, 0xff, // 139
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xf3, 0xff, 0x78, 0xff, 0xff, 0xff, // 140
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 141
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 142
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 143
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 144
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 145
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 146
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 147
  0xf8, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 148
  0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xf7, 0xff, 0xfc, 0xff, 0xff, 0xff, // 149
  0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xf1, 0x80, 0xfc, 0xff, 0xff, 0xff, // 150
  0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xf8, 0x00, 0xec, 0xff, 0xff, 0xff, // 151
  0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xfc, 0xbe, 0xcc, 0xff, 0xff, 0xff, // 152
  0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xbe, 0xcc, 0xff, 0xff, 0xff, // 153
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0xcc, 0xff, 0xff, 0xff, // 154
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0x80, 0xcc, 0xff, 0xff, 0xff, // 155
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe3, 0x9c, 0xcc, 0xff, 0xff, 0xff, // 156
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0xbe, 0xcc, 0xff, 0xff, 0xff, // 157
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xbe, 0xcc, 0xff, 0xff, 0xff, // 158
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0xcc, 0xff, 0xff, 0xff, // 159
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0xcc, 0xff, 0xff, 0xff, // 160
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbe, 0xcc, 0xff, 0xff, 0xff, // 161
  0xff, 0xfc, 0x1f, 0xc7, 0xe0, 0xfc, 0x0f, 0xf8, 0xf0, 0x3f, 0x87, 0x80, 0x7c, 0x1f, 0x87, 0xfc, 0xfe, 0x07, 0xfc, 0x0f, 0xff, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xbe, 0xcc, 0xff, 0xff, 0xff, // 162
  0xff, 0xf8, 0x0f, 0x07, 0xc0, 0x78, 0x07, 0xf8, 0xf0, 0x3f, 0x03, 0x80, 0x78, 0x0f, 0x01, 0xfc, 0xfe, 0x01, 0xf0, 0x07, 0xff, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x9c, 0xcc, 0xff, 0xff, 0xff, // 163
  0xff, 0xf9, 0xcf, 0x27, 0xde, 0x3b, 0xe3, 0xf4, 0xf3, 0xfe, 0x3b, 0xfc, 0xf1, 0xc6, 0x39, 0xf8, 0x7e, 0x79, 0xe3, 0xf7, 0xff, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x80, 0xcc, 0xff, 0xff, 0xff, // 164
  0xff, 0xf3, 0xe7, 0xe7, 0xff, 0x3f, 0xf3, 0xe4, 0xf3, 0xfc, 0x7f, 0xfc, 0xf3, 0xe6, 0x7c, 0xf8, 0x7e, 0x79, 0xe7, 0xff, 0x87, 0xe4, 0x3f, 0x0f, 0xff, 0xff, 0xff, 0xf3, 0x80, 0xec, 0xff, 0xff, 0xff, // 165
  0xff, 0xf3, 0xe7, 0xe7, 0xff, 0x3f, 0xe3, 0xec, 0xf0, 0x7c, 0xff, 0xfc, 0xf1, 0xc6, 0x7c, 0xf3, 0x3e, 0x79, 0xcf, 0xff, 0x03, 0xe0, 0x1c, 0x07, 0xff, 0xff, 0xff, 0xf3, 0xdf, 0xfc, 0xff, 0xff, 0xff, // 166
  0xff, 0xf3, 0xe7, 0xe7, 0xfe, 0x3e, 0x0f, 0xdc, 0xf0, 0x3c, 0x87, 0xf8, 0xfc, 0x1e, 0x38, 0xf3, 0x3e, 0x03, 0xcf, 0xff, 0x71, 0xe3, 0x8c, 0xf7, 0xff, 0xff, 0xff, 0xe3, 0x8c, 0xfc, 0xff, 0xff, 0xff, // 167
  0xff, 0xf3, 0xe7, 0xe7, 0xfe, 0x7e, 0x07, 0x9c, 0xf7, 0x1c, 0x03, 0xf9, 0xf8, 0x0f, 0x00, 0xf3, 0x3e, 0x03, 0xcf, 0xff, 0xf9, 0xe7, 0xc9, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x9c, 0xfc, 0xff, 0xff, 0xff, // 168
  0xff, 0xf3, 0xe7, 0xe7, 0xfc, 0xff, 0xe3, 0xbc, 0xff, 0x9c, 0x71, 0xf9, 0xf1, 0xc7, 0x84, 0xe7, 0x9e, 0x79, 0xcf, 0xff, 0x81, 0xe7, 0xc9, 0xff, 0xff, 0xff, 0xff, 0xc7, 0x3e, 0x60, 0xff, 0xff, 0xff, // 169
  0xff, 0xf3, 0xe7, 0xe7, 0xf9, 0xff, 0xf3, 0x00, 0x3f, 0x9c, 0xf9, 0xf1, 0xf3, 0xe7, 0xfc, 0xe0, 0x1e, 0x7c, 0xcf, 0xfe, 0x01, 0xe7, 0xc9, 0xff, 0xff, 0xff, 0xff, 0xef, 0x3e, 0x60, 0xff, 0xff, 0xff, // 170
  0xff, 0xf3, 0xe7, 0xe7, 0xf3, 0xff, 0xf3, 0x00, 0x3f, 0x9c, 0xf9, 0xf3, 0xf3, 0xe7, 0xf8, 0xc0, 0x0e, 0x7c, 0xe7, 0xfe, 0x79, 0xe7, 0xc9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 171
  0xff, 0xf9, 0xcf, 0xe7, 0xe7, 0xfb, 0xe3, 0xfc, 0xef, 0x1e, 0x71, 0xf3, 0xf1, 0xc7, 0x71, 0xcf, 0xce, 0x78, 0xe3, 0xf6, 0x71, 0xe3, 0x8c, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 172
  0xff, 0xf8, 0x0f, 0x00, 0xc0, 0x38, 0x07, 0xfc, 0xe0, 0x3e, 0x03, 0xe3, 0xf8, 0x0f, 0x03, 0xcf, 0xce, 0x01, 0xf0, 0x06, 0x01, 0xe0, 0x1c, 0x07, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 173
  0xff, 0xfc, 0x1f, 0x00, 0xc0, 0x3c, 0x0f, 0xfc, 0xf0, 0x7f, 0x87, 0xe7, 0xfc, 0x1f, 0x87, 0x9f, 0xe6, 0x03, 0xfc, 0x0f, 0x09, 0xe4, 0x3f, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 174
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 175
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, // 176
};


