#include "mbed.h"
#include "EM027BS013.h"
#include "image_data.h"

/*
 * Example taken from http://mbed.org/users/embeddedartists/code/app_epaper_EM027BS013/
 *  
 * The following macros makes it easier to specify all the 12 arguments to the
 * EM027BS013 constructor:
 */
 
/*
 * LPC4088EBB_SEC
 * --------------
 * Embedded Artists' LPC4088 QuickStart Board + LPC4088 Experiment Base Board. 
 * The display module should be connected using the 14-pos serial expansion
 * connector on the base board.
 */
#define LPC4088EBB_SEC   p13,p11,p12,p14,p10,p9,p20,p19,p37,p38,p17,p18


EM027BS013 epaper(LPC4088EBB_SEC);

/*
 Hardware Setup:
 
 - Jumpers JP1..JP6 should be in position 1-2
 - Jumpers in J14 should NOT be inserted
 - Jumper J7 should be inserted
 - Display in connector J5. 
*/

int main() {
    while(1) {
        epaper.drawImage((uint8_t*)&image_array_270_ea);
        wait(5);
        epaper.drawImage((uint8_t*)&image_array_270_text);
        wait(5);
        epaper.drawImage((uint8_t*)&image_array_270_1);
        wait(5);
        epaper.drawImage((uint8_t*)&image_array_270_2);
        wait(5);
    }
}
