/******************************************************************************
 * Includes
 *****************************************************************************/

#include "mbed.h"

#include "BubbleDemo.h"

#include "DmTftHX8353C.h"
#include "DmTftS6D0164.h"
#include "DmTftIli9325.h"
#include "DmTftIli9341.h"
#include "DmTftSsd2119.h"

/******************************************************************************
 * Typedefs and defines
 *****************************************************************************/

#define RESET_FLAG  \
  do { \
    if (abortTest) { \
      abortTest = false; \
      wait(0.04); \
    } \
  } while(false)


#if 0
  /* Displays without adapter (DM_TFT28_105 & DM_TFT35_107) */
  #define DM_PIN_CS_TOUCH   D4
  #define DM_PIN_CS_TFT     D10
  #define DM_PIN_CS_SDCARD  D8
  #define DM_PIN_CS_FLASH   D6
#else
  /* Displays with adapter (all other displays) */
  #define DM_PIN_CS_TFT     D4
  #define DM_PIN_CS_SDCARD  D10
#endif

/******************************************************************************
 * Local variables
 *****************************************************************************/

static InterruptIn buttonInterrupt(P2_10);
static DigitalOut led(LED1);


//DmTftHX8353C tft(p5, p7, p30, p17, p16);  /* DM-TFT18-101 if inserted in the 40-pin J12 contact */
DmTftHX8353C tft;                         /* DM-TFT18-101 with adapter in arduino J1 contact */
//DmTftS6D0164 tft;                         /* DM_TFT22_102 with adapter in arduino J1 contact */
//DmTftIli9325 tft;                         /* DM_TFT28_103 and DM_TFT24_104 with adapter in arduino J1 contact */
//DmTftIli9341 tft;                         /* DM_TFT28_105 directly in arduino J1 contact (no adapter) */
//DmTftSsd2119 tft;                         /* DM_TFT35_107 directly in arduino J1 contact (no adapter) */

#ifdef DM_PIN_CS_TOUCH
  DigitalInOut csTouch(DM_PIN_CS_TOUCH, PIN_OUTPUT, PullUp, 1);
#endif
DigitalInOut csDisplay(DM_PIN_CS_TFT, PIN_OUTPUT, PullUp, 1);
DigitalInOut csSDCard(DM_PIN_CS_SDCARD, PIN_OUTPUT, PullUp, 1);
#ifdef DM_PIN_CS_FLASH
  DigitalInOut csFlash(DM_PIN_CS_FLASH, PIN_OUTPUT, PullUp, 1);
#endif

/******************************************************************************
 * Global variables
 *****************************************************************************/

/******************************************************************************
 * Main
 *****************************************************************************/

/*
 Hardware Setup:
 
 - Jumpers JP1..JP6 should be in position 1-2
 - Jumpers in J14 should NOT be inserted
 - Jumper J7 should be inserted
 - Display in connector J12 (display will be outside of base boards boundaries)
   or in arduino socket J1 depending on display
*/

/*
 Test Comments:
 
 - This example can be used with the DM-TFT18-101 1.8" either in the 40-pin J12
   connector or on top of the DM-ADTAU-001 board in the arduino J1 socket.
 - The DM-TFT22-102, DM-TFT28-103 and DM-TFT24-104 must all be used on top
   of the DM-ADTAU-001 board in the arduino J1 socket.
 - The DM-TFT28-105 and DM-TFT35-107 displays have direct arduino pinning and
   can be inserted directly in the J1 socket.
*/

int main (void)
{
    tft.init();

    BubbleDemo bubbleDemo(&tft, tft.width(), tft.height());
    while (1) {    
        bubbleDemo.run(750, 20);
    }
}
