/******************************************************************************
 * Includes
 *****************************************************************************/

#include "mbed.h"

#include "BubbleDemo.h"

#include "DmTftHX8353C.h"

/******************************************************************************
 * Typedefs and defines
 *****************************************************************************/

/******************************************************************************
 * Local variables
 *****************************************************************************/

/* DM_TFT18_101 */
DmTftHX8353C tft(p5, p7, p30, p17, p16); // mosi,clk,cs,dc,rst

/******************************************************************************
 * Global variables
 *****************************************************************************/

/******************************************************************************
 * Main
 *****************************************************************************/

/*
 Hardware Setup:
 
 - Jumpers JP1..JP6 should be in position 1-2
 - Jumpers in J14 should NOT be inserted
 - Jumper J7 should be inserted
 - Display in connector J12 (display will be outside of base boards boundaries). 
*/

/*
 Test Comments:
 
 - This example is only for the DM-TFT-101 1.8" display as it is the only
   one with SPI interface AND 40-pin contact   
 - The display board's sd card cannot be accessed due to missing ChipSelect
 - The display cannot be used with the MCI interface on the base board as they
   share p30 (SDCLK and LCD_CS) so use SPI interface to use the base board's uSD 
*/

int main (void)
{
    tft.init();

    BubbleDemo bubbleDemo(&tft, tft.width(), tft.height());
    while (1) {    
        bubbleDemo.run(750, 20);
    }
}
