
#ifndef EWFRAMEWINDOW_H
#define EWFRAMEWINDOW_H

#include "EwWindow.h"
#include "EwPainter.h"

#include "FRAMEWIN.h"

enum ewFrameWindowButtonAlign_t {
    FrameWindowButtonLeft = FRAMEWIN_BUTTON_LEFT,
    FrameWindowButtonRight = FRAMEWIN_BUTTON_RIGHT,
};

enum ewFrameWindowColorIndex_t {
    FrameWindowColorIndexInactive = 0,
    FrameWindowColorIndexActive = 1
};

/**
 * This is a wrapper class for the emwin FRAMEWIN interface.
 */
class EwFrameWindow : public EwWindow {
public:

    EwFrameWindow(const char* pTitle, EwWindow* parent = 0);
    EwFrameWindow(int x, int y, int width, int height, const char* pTitle, EwWindow* parent = 0);

    void addCloseButton(ewFrameWindowButtonAlign_t align, int32_t offset);
    void addMaxButton(ewFrameWindowButtonAlign_t align, int32_t offset);
    // TODO: addMenu(ewMenu* pMenu);
    void addMinButton(ewFrameWindowButtonAlign_t align, int32_t offset);
    bool isActive();
    ewColor_t getBarColor(ewFrameWindowColorIndex_t idx);
    int32_t getBorderSize();
    const ewFont_t* getFont();
    void getText(char* pBuffer, int32_t maxLen);
    ewTextAlign_t getTextAlign();
    int32_t getTitleHeight();
    bool isMaximized();
    bool isMinimized();
    void maximize();
    void minimize();
    void restore();
    void setActive(bool active);
    void setBarColor(ewFrameWindowColorIndex_t idx, ewColor_t c);
    void setBorderSize(uint32_t size);
    void setClientColor(ewColor_t c);
    void setFont(const ewFont_t* pFont);
    void setMoveable(bool moveable);
    void setResizeable(bool resizeable);
    void setText(const char* s);
    void setTextAlign(ewTextAlign_t align);
    void setTextColor(ewFrameWindowColorIndex_t idx, ewColor_t c);
    void setTitleHeight(int32_t height);
    void setTitleVisible(bool visible);


    static ewColor_t getDefaultBarColor(ewFrameWindowColorIndex_t idx);
    static int32_t getDefaultBorderSize();
    static ewColor_t getDefaultClientColor();
    static const ewFont_t* getDefaultFont();
    static ewColor_t getDefaultTextColor(ewFrameWindowColorIndex_t idx);
    static int32_t getDefaultTitleHeight();

    static void setDefaultBarColor(ewFrameWindowColorIndex_t idx, ewColor_t c);
    static void setDefaultBorderSize(int32_t size);
    static void setDefaultClientColor(ewColor_t c);
    static void setDefaultTextColor(ewFrameWindowColorIndex_t idx, ewColor_t c);
    static void setDefaultTitleHeight(int32_t height);

private:

    void init(int x, int y, int width, int height, const char* pTitle, EwWindow* parent);

};

#endif
