#include "mbed.h"

#include "EwButton.h"


EwButton::EwButton(EwWindow* parent) : EwWindow(parent) {
    init(0, 0, 0, 0, parent);
}

EwButton::EwButton(int x, int y, int width, int height, EwWindow* parent) :
	        EwWindow(x, y, width, height, parent) {

    init(x, y, width, height, parent);
}

void EwButton::setText(const char* text) {
    BUTTON_SetText(_hWnd, text);
}

void EwButton::getText(char* pBuf, int bufSz) {
    BUTTON_GetText(_hWnd, pBuf, bufSz);
}

ewColor_t EwButton::getBackgroundColor(ewButtonColorIndex_t idx) {
    return BUTTON_GetBkColor(_hWnd, idx);
}

void EwButton::setBackgroundColor(ewButtonColorIndex_t idx, ewColor_t c) {
    BUTTON_SetBkColor(_hWnd, idx, c);
}

const ewFont_t* EwButton::getFont() {
    return BUTTON_GetFont(_hWnd);
}

void EwButton::setFont(const ewFont_t* pFont) {
    BUTTON_SetFont(_hWnd, pFont);
}

ewTextAlign_t EwButton::getTextAlign() {
    return (ewTextAlign_t)BUTTON_GetTextAlign(_hWnd);
}

void EwButton::setTextAlign(ewTextAlign_t align) {
    BUTTON_SetTextAlign(_hWnd, align);
}

ewColor_t EwButton::getTextColor(ewButtonColorIndex_t idx) {
    return BUTTON_GetTextColor(_hWnd, idx);
}

void EwButton::setTextColor(ewButtonColorIndex_t idx, ewColor_t c) {
    BUTTON_SetTextColor(_hWnd, idx, c);
}

void EwButton::setFocusColor(ewColor_t c) {
    BUTTON_SetFocusColor(_hWnd, c);
}

void EwButton::setFocussable(bool focussable) {
    BUTTON_SetFocussable(_hWnd, (focussable ? 1 : 0));
}

void EwButton::setPressed(bool pressed) {
    BUTTON_SetPressed(_hWnd, (pressed ? 1 : 0));
}

bool EwButton::isPressed() {
    return (BUTTON_IsPressed(_hWnd) == 1);
}


void EwButton::setTextOffset(int32_t xPos, int32_t yPos) {
    BUTTON_SetTextOffset(_hWnd, xPos, yPos);
}

const ewBitmap_t* EwButton::getBitmap(ewButtonColorIndex_t idx) {
    return BUTTON_GetBitmap(_hWnd, idx);
}

void EwButton::setBitmap(ewButtonColorIndex_t idx, const ewBitmap_t* pBitmap) {
    BUTTON_SetBitmap(_hWnd, idx, pBitmap);
}

void EwButton::setBitmap(ewButtonColorIndex_t idx, const ewBitmap_t* pBitmap, int32_t x, int32_t y) {
    BUTTON_SetBitmapEx(_hWnd, idx, pBitmap, x, y);
}

void EwButton::setPressedListener(void (*fptr)(EwWindow* w)) {
    _pressedListener.attach(fptr);
}

void EwButton::setReleasedListener(void (*fptr)(EwWindow* w)) {
    _releasedListener.attach(fptr);
}

void EwButton::setClickedListener(void (*fptr)(EwWindow* w)) {
    _clickedListener.attach(fptr);
}

ewColor_t EwButton::getDefaultBackgroundColor(ewButtonColorIndex_t idx) {
    return BUTTON_GetDefaultBkColor(idx);
}

void EwButton::setDefaultBackgroundColor(ewButtonColorIndex_t idx, ewColor_t c) {
    BUTTON_SetDefaultBkColor(c, idx);
}

void EwButton::setDefaultFont(const ewFont_t* pFont) {
    BUTTON_SetDefaultFont(pFont);
}

const ewFont_t* EwButton::getDefaultFont() {
    return BUTTON_GetDefaultFont();
}

ewTextAlign_t EwButton::getDefaultTextAlign() {
    return (ewTextAlign_t) BUTTON_GetDefaultTextAlign();
}

void EwButton::setDefaultTextAlign(ewTextAlign_t align) {
    BUTTON_SetDefaultTextAlign(align);
}

ewColor_t EwButton::getDefaultTextColor(ewButtonColorIndex_t idx) {
    return BUTTON_GetDefaultTextColor(idx);
}

void EwButton::setDefaultTextColor(ewButtonColorIndex_t idx, ewColor_t c) {
    BUTTON_SetDefaultTextColor(c, idx);
}

void EwButton::setDefaultFocusColor(ewColor_t c) {
    BUTTON_SetDefaultFocusColor(c);
}


void EwButton::init(int x, int y, int width, int height, EwWindow* parent) {
    BUTTON_Handle h;
    GUI_HWIN hWin = 0;

    _inputStatePressed = false;

    if (parent) {
        hWin = _getHandle(parent);
    }

    h = BUTTON_CreateEx(x, y, width, height, hWin, (WM_CF_SHOW| WM_CF_MEMDEV),
            0, _guiWidgetId++);
    _setNewHandle(h, _callback);
}

void EwButton::handleInput(bool pressed, bool onWidget) {

    // pressed will always be on top of widget
    if (pressed && !_inputStatePressed) {
        _pressedListener.call(this);
    }

    // always generate a released event (even if not released on top of widget)
    if (!pressed && _inputStatePressed) {
        _releasedListener.call(this);
    }

    if (!pressed && _inputStatePressed && onWidget) {
        _clickedListener.call(this);
    }

    _inputStatePressed = pressed;
}

void EwButton::_callback(WM_MESSAGE* pMsg, EwWindow* w) {
    GUI_PID_STATE* pidState;

    // always let button widget process the event first
    BUTTON_Callback(pMsg);

    switch(pMsg->MsgId) {
    case WM_TOUCH:
        pidState = (GUI_PID_STATE*)pMsg->Data.p;

        EwButton* b = (EwButton*)w;
        b->handleInput((pidState->Pressed == 1),
                (pidState->Pressed == 1 || pidState->Pressed == 0));


        break;
    }

}

