#include "EwGui.h"
#include "mbed.h"


#include "WM.h"

#include "emwin_port.h"

EwGui::EwGui() {
    _initialized = false;
    _penIsDown = false;;

    _touchX = 0;
    _touchY = 0;
    
    memset(&_touchState, 0, sizeof(GUI_PID_STATE));
}

void EwGui::exec() {
    WM_Exec();
}

void EwGui::execTouch() {
    int32_t x = 0, y = 0, z = 0;

    getTouchValues(&x, &y, &z);

    _touchState.x = x;
    _touchState.y = y;
    _touchState.Pressed = (z != 0) ? 1 : 0;
    GUI_PID_StoreState(&_touchState);
}

void EwGui::init() {

    if (!_initialized) {

        // register class with porting layer
        ew_registerGuiHandle(this);

        GUI_Init();
        _initialized = true;

        // TODO:
//        GUI_CURSOR_Show();
//        GUI_CURSOR_Select(&GUI_CursorCrossL);
    }

}


