#include "mbed.h"

#include "EwFrameWindow.h"


EwFrameWindow::EwFrameWindow(const char* pTitle, EwWindow* parent) : EwWindow(parent) {
    init(0, 0, 0, 0, pTitle, parent);
}

EwFrameWindow::EwFrameWindow(int x, int y, int width, int height, const char* pTitle, EwWindow* parent) :
	        EwWindow(x, y, width, height, parent) {

    init(x, y, width, height, pTitle, parent);
}


void EwFrameWindow::addCloseButton(ewFrameWindowButtonAlign_t align, int32_t offset) {
    FRAMEWIN_AddCloseButton(_hWnd, align, offset);
}

void EwFrameWindow::addMaxButton(ewFrameWindowButtonAlign_t align, int32_t offset) {
    FRAMEWIN_AddMaxButton(_hWnd, align, offset);
}

void EwFrameWindow::addMinButton(ewFrameWindowButtonAlign_t align, int32_t offset) {
    FRAMEWIN_AddMinButton(_hWnd, align, offset);
}

bool EwFrameWindow::isActive() {
    return (FRAMEWIN_GetActive(_hWnd) == 1);
}

ewColor_t EwFrameWindow::getBarColor(ewFrameWindowColorIndex_t idx) {
    return FRAMEWIN_GetBarColor(_hWnd, idx);
}

int32_t EwFrameWindow::getBorderSize() {
    return FRAMEWIN_GetBorderSize(_hWnd);
}

const ewFont_t* EwFrameWindow::getFont() {
    return FRAMEWIN_GetFont(_hWnd);
}

void EwFrameWindow::getText(char* pBuffer, int32_t maxLen) {
    FRAMEWIN_GetText(_hWnd, pBuffer, maxLen);
}

ewTextAlign_t EwFrameWindow::getTextAlign() {
    return (ewTextAlign_t) FRAMEWIN_GetTextAlign(_hWnd);
}

int32_t EwFrameWindow::getTitleHeight() {
    return FRAMEWIN_GetTitleHeight(_hWnd);
}

bool EwFrameWindow::isMaximized() {
    return (FRAMEWIN_IsMaximized(_hWnd) == 1);
}

bool EwFrameWindow::isMinimized() {
    return (FRAMEWIN_IsMinimized(_hWnd) == 1);
}

void EwFrameWindow::maximize() {
    FRAMEWIN_Maximize(_hWnd);
}

void EwFrameWindow::minimize() {
    FRAMEWIN_Minimize(_hWnd);
}

void EwFrameWindow::restore() {
    FRAMEWIN_Restore(_hWnd);
}

void EwFrameWindow::setActive(bool active) {
    FRAMEWIN_SetActive(_hWnd, (active ? 1 : 0));
}

void EwFrameWindow::setBarColor(ewFrameWindowColorIndex_t idx, ewColor_t c) {
    FRAMEWIN_SetBarColor(_hWnd, idx, c);
}

void EwFrameWindow::setBorderSize(uint32_t size) {
    FRAMEWIN_SetBorderSize(_hWnd, size);
}

void EwFrameWindow::setClientColor(ewColor_t c) {
    FRAMEWIN_SetClientColor(_hWnd, c);
}

void EwFrameWindow::setFont(const ewFont_t* pFont) {
    FRAMEWIN_SetFont(_hWnd, pFont);
}

void EwFrameWindow::setMoveable(bool moveable) {
    FRAMEWIN_SetMoveable(_hWnd, (moveable ? 1 : 0));
}

void EwFrameWindow::setResizeable(bool resizeable) {
    FRAMEWIN_SetResizeable(_hWnd, (resizeable ? 1 : 0));
}

void EwFrameWindow::setText(const char* s) {
    FRAMEWIN_SetText(_hWnd, s);
}

void EwFrameWindow::setTextAlign(ewTextAlign_t align) {
    FRAMEWIN_SetTextAlign(_hWnd, align);
}

void EwFrameWindow::setTextColor(ewFrameWindowColorIndex_t idx, ewColor_t c) {
    FRAMEWIN_SetTextColorEx(_hWnd, idx, c);
}

void EwFrameWindow::setTitleHeight(int32_t height) {
    FRAMEWIN_SetTitleHeight(_hWnd, height);
}

void EwFrameWindow::setTitleVisible(bool visible) {
    FRAMEWIN_SetTitleVis(_hWnd, (visible ? 1 : 0));
}


ewColor_t EwFrameWindow::getDefaultBarColor(ewFrameWindowColorIndex_t idx) {
    return FRAMEWIN_GetDefaultBarColor(idx);
}

int32_t EwFrameWindow::getDefaultBorderSize() {
    return FRAMEWIN_GetDefaultBorderSize();
}

ewColor_t EwFrameWindow::getDefaultClientColor() {
    return FRAMEWIN_GetDefaultClientColor();
}

const ewFont_t* EwFrameWindow::getDefaultFont() {
    return FRAMEWIN_GetDefaultFont();
}

ewColor_t EwFrameWindow::getDefaultTextColor(ewFrameWindowColorIndex_t idx) {
    return FRAMEWIN_GetDefaultTextColor(idx);
}

int32_t EwFrameWindow::getDefaultTitleHeight() {
    return FRAMEWIN_GetDefaultTitleHeight();
}

void EwFrameWindow::setDefaultBarColor(ewFrameWindowColorIndex_t idx, ewColor_t c) {
    FRAMEWIN_SetDefaultBarColor(idx, c);
}

void EwFrameWindow::setDefaultBorderSize(int32_t size) {
    FRAMEWIN_SetDefaultBorderSize(size);
}

void EwFrameWindow::setDefaultClientColor(ewColor_t c) {
    FRAMEWIN_SetDefaultClientColor(c);
}

void EwFrameWindow::setDefaultTextColor(ewFrameWindowColorIndex_t idx, ewColor_t c) {
    FRAMEWIN_SetDefaultTextColor(idx, c);
}

void EwFrameWindow::setDefaultTitleHeight(int32_t height) {
    FRAMEWIN_SetDefaultTitleHeight(height);
}



void EwFrameWindow::init(int x, int y, int width, int height, const char* pTitle, EwWindow* parent) {
    FRAMEWIN_Handle h;
    GUI_HWIN hWin = 0;

    if (parent) {
        hWin = _getHandle(parent);
    }

    h = FRAMEWIN_CreateEx(x, y, width, height, hWin, (WM_CF_SHOW| WM_CF_MEMDEV),
            FRAMEWIN_CF_MOVEABLE, _guiWidgetId++, pTitle, NULL);
    _setNewHandle(h, NULL);
}

