
#ifndef EWEDIT_H
#define EWEDIT_H

#include "EwPainter.h"
#include "EwWindow.h"

#include "EDIT.h"


enum ewEditColorIndex_t {
    EditColorIndexDisabled = EDIT_CI_DISABELD,
    EditColorIndexEnabled = EDIT_CI_ENABELD,
};

enum ewEditMode_t {
    EditModeNormal = GUI_EDIT_NORMAL,
    EditModeSigned = GUI_EDIT_SIGNED,
    EditModeSuppressLeadingZeros = GUI_EDIT_SUPPRESS_LEADING_ZEROES
};

/**
 * This is a wrapper class for the emwin EDIT interface.
 */
class EwEdit : public EwWindow {
public:

    EwEdit(int maxLen, EwWindow* parent = 0);
    EwEdit(int x, int y, int width, int height, int maxLen, EwWindow* parent = 0);

    // TODO: enum or define? GUI_KEY_BACKSPACE
    void addKey(int32_t key);
    void enableBlink(int32_t period, bool on);
    ewColor_t getBackgroundColor(ewEditColorIndex_t idx);
    int32_t getCursorCharPosition();
    void getCursorPixelPosition(int32_t* x, int32_t* y);
    float getFloatValue();
    const ewFont_t* getFont();
    int32_t getNumChars();
    void getText(char* pBuffer, int32_t maxLen);
    ewColor_t getTextColor(ewEditColorIndex_t idx);
    int32_t getValue();
    void setBinMode(uint32_t value, uint32_t min, uint32_t max);
    void setBackgroundColor(ewEditColorIndex_t idx, ewColor_t c);
    void setCursorAtChar(int32_t charPos);
    void setCursorAtPixel(int32_t pos);
    void setDecimalMode(int32_t value, int32_t min, int32_t max, int32_t shift, ewEditMode_t mode);
    void setFloatMode(float value, float min, float max, int32_t shift, ewEditMode_t mode);
    void setFloatValue(float value);
    void setFocussable(bool focussable);
    void setFont(const ewFont_t* pFont);
    void setHexMode(uint32_t value, uint32_t min, uint32_t max);
    void setInsertMode(bool on);
    void setMaximumLength(int32_t maxLen);
    void setSelection(int32_t firstChar, int32_t lastChar);
    void setText(const char* s);
    void setTextAlign(ewTextAlign_t align);
    void setTextColor(ewEditColorIndex_t idx, ewColor_t c);
    void setTextMode();
    void setULongMode(uint32_t value, uint32_t min, uint32_t max);
    void setValue(int32_t value);



    static ewColor_t getDefaultBackgroundColor(ewEditColorIndex_t idx);
    static const ewFont_t* getDefaultFont();
    static ewTextAlign_t getDefaultTextAlign();
    static ewColor_t getDefaultTextColor(ewEditColorIndex_t idx);

    static void setDefaultBackgroundColor(ewEditColorIndex_t idx, ewColor_t c);
    static void setDefaultFont(const ewFont_t* pFont);
    static void setDefaultTextAlign(ewTextAlign_t align);
    static void setDefaultTextColor(ewEditColorIndex_t idx, ewColor_t c);

    static uint32_t editBin(uint32_t value, uint32_t min, uint32_t max, int32_t len, int32_t width);
    static uint32_t editDec(int32_t value, int32_t min, int32_t max, int32_t len, int32_t width, int32_t shift, ewEditMode_t mode);
    static float editFloat(float value, float min, float max, int32_t len, int32_t width, int32_t shift, ewEditMode_t mode);
    static uint32_t editHex(uint32_t value, uint32_t min, uint32_t max, int32_t len, int32_t width);
    static void editString(char* pString, int32_t len, int32_t width);

private:


    void init(int x, int y, int width, int height, int maxLen, EwWindow* parent);


    static void _callback(WM_MESSAGE* pMsg, EwWindow* w);


};

#endif
