#include "mbed.h"

#include "EwEdit.h"


EwEdit::EwEdit(int maxLen, EwWindow* parent) : EwWindow(parent) {
    init(0, 0, 0, 0, maxLen, parent);
}

EwEdit::EwEdit(int x, int y, int width, int height, int maxLen, EwWindow* parent) :
	        EwWindow(x, y, width, height, parent) {

    init(x, y, width, height, maxLen, parent);
}

void EwEdit::addKey(int32_t key) {
    EDIT_AddKey(_hWnd, key);
}

void EwEdit::enableBlink(int32_t period, bool on) {
    EDIT_EnableBlink(_hWnd, period, (on ? 1 : 0));
}

ewColor_t EwEdit::getBackgroundColor(ewEditColorIndex_t idx) {
    return EDIT_GetBkColor(_hWnd, idx);
}

int32_t EwEdit::getCursorCharPosition() {
    return EDIT_GetCursorCharPos(_hWnd);
}

void EwEdit::getCursorPixelPosition(int32_t* x, int32_t* y) {
    EDIT_GetCursorPixelPos(_hWnd, (int*)x, (int*)y);
}

float EwEdit::getFloatValue() {
    return EDIT_GetFloatValue(_hWnd);
}

const ewFont_t* EwEdit::getFont() {
    return EDIT_GetFont(_hWnd);
}

int32_t EwEdit::getNumChars() {
    return EDIT_GetNumChars(_hWnd);
}

void EwEdit::getText(char* pBuffer, int32_t maxLen) {
    EDIT_GetText(_hWnd, pBuffer, maxLen);
}

ewColor_t EwEdit::getTextColor(ewEditColorIndex_t idx) {
    return EDIT_GetTextColor(_hWnd, idx);
}

int32_t EwEdit::getValue() {
    return EDIT_GetValue(_hWnd);
}

void EwEdit::setBinMode(uint32_t value, uint32_t min, uint32_t max) {
    EDIT_SetBinMode(_hWnd, value, min, max);
}

void EwEdit::setBackgroundColor(ewEditColorIndex_t idx, ewColor_t c) {
    EDIT_SetBkColor(_hWnd, idx, c);
}

void EwEdit::setCursorAtChar(int32_t charPos) {
    EDIT_SetCursorAtChar(_hWnd, charPos);
}

void EwEdit::setCursorAtPixel(int32_t pos) {
    EDIT_SetCursorAtPixel(_hWnd, pos);
}

void EwEdit::setDecimalMode(int32_t value, int32_t min, int32_t max, int32_t shift, ewEditMode_t mode) {
    EDIT_SetDecMode(_hWnd, value, min, max, shift, mode);
}

void EwEdit::setFloatMode(float value, float min, float max, int32_t shift, ewEditMode_t mode) {
    EDIT_SetFloatMode(_hWnd, value, min, max, shift, mode);
}

void EwEdit::setFloatValue(float value) {
    EDIT_SetFloatValue(_hWnd, value);
}

void EwEdit::setFocussable(bool focussable) {
    EDIT_SetFocussable(_hWnd, (focussable ? 1 : 0));
}

void EwEdit::setFont(const ewFont_t* pFont) {
    EDIT_SetFont(_hWnd, pFont);
}

void EwEdit::setHexMode(uint32_t value, uint32_t min, uint32_t max) {
    EDIT_SetHexMode(_hWnd, value, min, max);
}

void EwEdit::setInsertMode(bool on) {
    EDIT_SetInsertMode(_hWnd, (on ? 1 : 0));
}

void EwEdit::setMaximumLength(int32_t maxLen) {
    EDIT_SetMaxLen(_hWnd, maxLen);
}

void EwEdit::setSelection(int32_t firstChar, int32_t lastChar) {
    EDIT_SetSel(_hWnd, firstChar, lastChar);
}

void EwEdit::setText(const char* s) {
    EDIT_SetText(_hWnd, s);
}

void EwEdit::setTextAlign(ewTextAlign_t align) {
    EDIT_SetTextAlign(_hWnd, align);
}

void EwEdit::setTextColor(ewEditColorIndex_t idx, ewColor_t c) {
    EDIT_SetTextColor(_hWnd, idx, c);
}

void EwEdit::setTextMode() {
    EDIT_SetTextMode(_hWnd);
}

void EwEdit::setULongMode(uint32_t value, uint32_t min, uint32_t max) {
    EDIT_SetUlongMode(_hWnd, value, min, max);
}

void EwEdit::setValue(int32_t value) {
    EDIT_SetValue(_hWnd, value);
}


ewColor_t EwEdit::getDefaultBackgroundColor(ewEditColorIndex_t idx) {
    return EDIT_GetDefaultBkColor(idx);
}

const ewFont_t* EwEdit::getDefaultFont() {
    return EDIT_GetDefaultFont();
}

ewTextAlign_t EwEdit::getDefaultTextAlign() {
    return (ewTextAlign_t)EDIT_GetDefaultTextAlign();
}

ewColor_t EwEdit::getDefaultTextColor(ewEditColorIndex_t idx) {
    return EDIT_GetDefaultTextColor(idx);
}

void EwEdit::setDefaultBackgroundColor(ewEditColorIndex_t idx, ewColor_t c) {
    EDIT_SetDefaultBkColor(idx, c);
}

void EwEdit::setDefaultFont(const ewFont_t* pFont) {
    EDIT_SetDefaultFont(pFont);
}

void EwEdit::setDefaultTextAlign(ewTextAlign_t align) {
    EDIT_SetDefaultTextAlign(align);
}

void EwEdit::setDefaultTextColor(ewEditColorIndex_t idx, ewColor_t c) {
    EDIT_SetDefaultTextColor(idx, c);
}

uint32_t EwEdit::editBin(uint32_t value, uint32_t min, uint32_t max, int32_t len, int32_t width) {
    return GUI_EditBin(value, min, max, len, width);
}

uint32_t EwEdit::editDec(int32_t value, int32_t min, int32_t max, int32_t len, int32_t width, int32_t shift, ewEditMode_t mode) {
    return GUI_EditDec(value, min, max, len, width, shift, mode);
}

float EwEdit::editFloat(float value, float min, float max, int32_t len, int32_t width, int32_t shift, ewEditMode_t mode) {
    return GUI_EditFloat(value, min, max, len, width, shift, mode);
}

uint32_t EwEdit::editHex(uint32_t value, uint32_t min, uint32_t max, int32_t len, int32_t width) {
    return GUI_EditHex(value, min, max, len, width);
}

void EwEdit::editString(char* pString, int32_t len, int32_t width) {
    GUI_EditString(pString, len, width);
}


void EwEdit::init(int x, int y, int width, int height, int maxLen, EwWindow* parent) {
    EDIT_Handle h;
    GUI_HWIN hWin = 0;


    if (parent) {
        hWin = _getHandle(parent);
    }

    h = EDIT_CreateEx(x, y, width, height, hWin, (WM_CF_SHOW| WM_CF_MEMDEV),
            0, _guiWidgetId++, maxLen);
    _setNewHandle(h, _callback);
}


void EwEdit::_callback(WM_MESSAGE* pMsg, EwWindow* w) {
    EDIT_Callback(pMsg);
}

