#include "mbed.h"

#include "EwDropDown.h"


EwDropDown::EwDropDown(EwWindow* parent) : EwWindow(parent) {
    init(0, 0, 0, 0, parent);
}

EwDropDown::EwDropDown(int x, int y, int width, int height, EwWindow* parent) :
	        EwWindow(x, y, width, height, parent) {

    init(x, y, width, height, parent);
}

void EwDropDown::addString(const char* s) {
    DROPDOWN_AddString(_hWnd, s);
}

void EwDropDown::collapse() {
    DROPDOWN_Collapse(_hWnd);
}

void EwDropDown::decrementSelection() {
    DROPDOWN_DecSel(_hWnd);
}

void EwDropDown::deleteItem(uint32_t idx) {
    DROPDOWN_DeleteItem(_hWnd, idx);
}

void EwDropDown::expand() {
    DROPDOWN_Expand(_hWnd);
}

bool EwDropDown::isItemDisabled(uint32_t idx) {
    return (DROPDOWN_GetItemDisabled(_hWnd, idx) == 1);
}

bool EwDropDown::getItemText(uint32_t idx, char* pBuffer, int maxSize) {
    return (DROPDOWN_GetItemText(_hWnd, idx, pBuffer, maxSize) == 0);
}

int EwDropDown::getNumItems() {
    return DROPDOWN_GetNumItems(_hWnd);
}

int32_t EwDropDown::getSelectedIndex() {
    return DROPDOWN_GetSel(_hWnd);
}

void EwDropDown::incrementSelection() {
    DROPDOWN_IncSel(_hWnd);
}

void EwDropDown::insertString(const char* s, uint32_t idx) {
    DROPDOWN_InsertString(_hWnd, s, idx);
}

void EwDropDown::setAutoScroll(bool on) {
    DROPDOWN_SetAutoScroll(_hWnd, (on ? 1 : 0));
}

void EwDropDown::setBackgroundColor(ewDropDownColorIndex_t idx, ewColor_t c) {
    DROPDOWN_SetBkColor(_hWnd, idx, c);
}

void EwDropDown::setColor(ewDropDownColorIndex_t idx, ewColor_t c) {
    DROPDOWN_SetColor(_hWnd, idx, c);
}

void EwDropDown::setFont(const ewFont_t* pFont) {
    DROPDOWN_SetFont(_hWnd, pFont);
}

void EwDropDown::setItemEnableState(uint32_t idx, bool enabled) {
    DROPDOWN_SetItemDisabled(_hWnd, idx, (enabled ? 1 : 0));
}

void EwDropDown::setScrollbarColor(ewScrollBarColorIndex_t idx, ewColor_t c) {
    DROPDOWN_SetScrollbarColor(_hWnd, idx, c);
}

void EwDropDown::setScrollbarWidth(uint32_t width) {
    DROPDOWN_SetScrollbarWidth(_hWnd, width);
}

void EwDropDown::setSelectedItem(int32_t idx) {
    DROPDOWN_SetSel(_hWnd, idx);
}

void EwDropDown::setItemSpacing(uint32_t spacing) {
    DROPDOWN_SetItemSpacing(_hWnd, spacing);
}

void EwDropDown::setTextAlign(ewTextAlign_t align) {
    DROPDOWN_SetTextAlign(_hWnd, align);
}

void EwDropDown::setTextColor(ewDropDownColorIndex_t idx, ewColor_t c) {
    DROPDOWN_SetTextColor(_hWnd, idx, c);
}

void EwDropDown::setTextHeight(uint32_t height) {
    DROPDOWN_SetTextHeight(_hWnd, height);
}

void EwDropDown::setUpMode(bool upMode) {
    DROPDOWN_SetUpMode(_hWnd, (upMode ? 1 : 0));
}

void EwDropDown::setSelectionChangedListener(void (*fptr)(EwWindow* w)) {
    _selChangedListener.attach(fptr);
}

ewColor_t EwDropDown::getDefaultBackgroundColor(ewDropDownColorIndex_t idx) {
    return DROPDOWN_GetDefaultBkColor(idx);
}

ewColor_t EwDropDown::getDefaultColor(ewDropDownColorIndex_t idx) {
    return DROPDOWN_GetDefaultColor(idx);
}

ewColor_t EwDropDown::getDefaultScrollbarColor(ewDropDownColorIndex_t idx) {
    return DROPDOWN_GetDefaultScrollbarColor(idx);
}

const ewFont_t* EwDropDown::getDefaultFont() {
    return DROPDOWN_GetDefaultFont();
}

void EwDropDown::setDefaultBackgroundColor(ewDropDownColorIndex_t idx, ewColor_t c) {
    DROPDOWN_SetDefaultBkColor(idx, c);
}

void EwDropDown::setDefaultColor(ewDropDownColorIndex_t idx, ewColor_t c) {
    DROPDOWN_SetDefaultColor(idx, c);
}

void EwDropDown::setDefaultFont(const ewFont_t* pFont) {
    DROPDOWN_SetDefaultFont(pFont);
}

void EwDropDown::setDefaultScrollbarColor(ewScrollBarColorIndex_t idx, ewColor_t c) {
    DROPDOWN_SetDefaultScrollbarColor(idx, c);
}


void EwDropDown::init(int x, int y, int width, int height, EwWindow* parent) {
    DROPDOWN_Handle h;
    GUI_HWIN hWin = 0;


    if (parent) {
        hWin = _getHandle(parent);
    }

    h = DROPDOWN_CreateEx(x, y, width, height, hWin, (WM_CF_SHOW| WM_CF_MEMDEV),
            0, _guiWidgetId++);
    _setNewHandle(h, _callback);
}

void EwDropDown::handleSelectionChanged() {
    _selChangedListener.call(this);
}



void EwDropDown::_callback(WM_MESSAGE* pMsg, EwWindow* w) {
    bool selChanged = false;

    EwDropDown* b = (EwDropDown*)w;


    if (pMsg->MsgId == WM_NOTIFY_PARENT && pMsg->Data.v == WM_NOTIFICATION_SEL_CHANGED) {
        selChanged = true;
    }
    DROPDOWN_Callback(pMsg);


    if (selChanged) {
        b->handleSelectionChanged();
    }

}

