#include "mbed.h"

#include "EwCheckBox.h"


EwCheckBox::EwCheckBox(EwWindow* parent) : EwWindow(parent) {
    init(0, 0, 0, 0, parent);
}

EwCheckBox::EwCheckBox(int x, int y, int width, int height, EwWindow* parent) :
	        EwWindow(x, y, width, height, parent) {

    init(x, y, width, height, parent);
}


ewCheckBoxState_t EwCheckBox::getState() {
    return (ewCheckBoxState_t)CHECKBOX_GetState(_hWnd);
}

void EwCheckBox::setState(ewCheckBoxState_t state) {
    ewCheckBoxState_t prev = getState();
    CHECKBOX_SetState(_hWnd, state);

    if (state != prev) {
        handleStateChanged();
    }
}

void EwCheckBox::setTristate(bool on) {
    _isTristate = on;
    if (on) {
        CHECKBOX_SetNumStates(_hWnd, 3);
    }
    else {
        CHECKBOX_SetNumStates(_hWnd, 2);
    }
}

bool EwCheckBox::isTristate() {
    return _isTristate;
}

void EwCheckBox::setText(const char* text) {
    CHECKBOX_SetText(_hWnd, text);
}

void EwCheckBox::getText(char* pBuf, int bufSz) {
    CHECKBOX_GetText(_hWnd, pBuf, bufSz);
}

void EwCheckBox::setBackgroundColor(ewColor_t c) {
    CHECKBOX_SetBkColor(_hWnd, c);
}

void EwCheckBox::setBoxBackgroundColor(ewColor_t c, ewCheckBoxColorIndex_t idx) {
    CHECKBOX_SetBoxBkColor(_hWnd, c, idx);
}

void EwCheckBox::setFont(const ewFont_t* pFont) {
    CHECKBOX_SetFont(_hWnd, pFont);
}

void EwCheckBox::setTextAlign(ewTextAlign_t align) {
    CHECKBOX_SetTextAlign(_hWnd, align);
}

void EwCheckBox::setTextColor(ewColor_t c) {
    CHECKBOX_SetTextColor(_hWnd, c);
}

void EwCheckBox::setFocusColor(ewColor_t c) {
    CHECKBOX_SetFocusColor(_hWnd, c);
}

void EwCheckBox::setImage(ewBitmap_t* pBitmap, ewCheckBoxBitmapIndex_t idx) {
    CHECKBOX_SetImage(_hWnd, pBitmap, idx);
}

void EwCheckBox::setSpacing(int32_t spacing) {
    CHECKBOX_SetSpacing(_hWnd, spacing);
}

void EwCheckBox::setChangedListener(void (*fptr)(EwWindow* w)) {
    _changedListener.attach(fptr);
}

ewColor_t EwCheckBox::getDefaultBackgroundColor() {
    return CHECKBOX_GetDefaultBkColor();
}

void EwCheckBox::setDefaultBackgroundColor(ewColor_t c) {
    CHECKBOX_SetDefaultBkColor(c);
}

const ewFont_t* EwCheckBox::getDefaultFont() {
    return CHECKBOX_GetDefaultFont();
}

void EwCheckBox::setDefaultFont(const ewFont_t* pFont) {
    CHECKBOX_SetDefaultFont(pFont);
}

ewColor_t EwCheckBox::getDefaultTextColor() {
    return CHECKBOX_GetDefaultTextColor();
}

void EwCheckBox::setDefaultTextColor(ewColor_t c) {
    CHECKBOX_SetDefaultTextColor(c);
}

void EwCheckBox::setDefaultFocusColor(ewColor_t c) {
    CHECKBOX_SetDefaultFocusColor(c);
}

int32_t EwCheckBox::getDefaultSpacing() {
    return CHECKBOX_GetDefaultSpacing();
}

void EwCheckBox::setDefaultSpacing(int32_t spacing) {
    CHECKBOX_SetDefaultSpacing(spacing);
}

void EwCheckBox::setDefaultImage(ewBitmap_t* pBitmap, ewCheckBoxBitmapIndex_t idx) {
    CHECKBOX_SetDefaultImage(pBitmap, idx);
}


void EwCheckBox::init(int x, int y, int width, int height, EwWindow* parent) {
    CHECKBOX_Handle h;
    GUI_HWIN hWin = 0;

    _isTristate = false;

    if (parent) {
        hWin = _getHandle(parent);
    }

    h = CHECKBOX_CreateEx(x, y, width, height, hWin, (WM_CF_SHOW| WM_CF_MEMDEV),
            0, _guiWidgetId++);
    _setNewHandle(h, _callback);
}

void EwCheckBox::handleStateChanged() {
    _changedListener.call(this);
}

void EwCheckBox::_callback(WM_MESSAGE* pMsg, EwWindow* w) {
    ewCheckBoxState_t prevState;

    EwCheckBox* b = (EwCheckBox*)w;

    // get state before message has been processed
    if (pMsg->MsgId == WM_TOUCH) {
        prevState =  b->getState();
    }

    CHECKBOX_Callback(pMsg);

    // check if the state has changed after processing the message
    if (pMsg->MsgId == WM_TOUCH) {
        if (b->getState() != prevState) {
            b->handleStateChanged();
        }
    }



}

