
#ifndef EWBUTTON_H
#define EWBUTTON_H

#include "EwPainter.h"
#include "EwWindow.h"
#include "EwFunctionPointer.h"

#include "BUTTON.h"

enum ewButtonColorIndex_t {
    ButtonColorIndexDisabled = BUTTON_CI_DISABLED,
    ButtonColorIndexPressed = BUTTON_CI_PRESSED,
    ButtonColorIndexUnpressed = BUTTON_CI_UNPRESSED,
};

/**
 * This is a wrapper class for the emwin BUTTON interface.
 */
class EwButton : public EwWindow {
public:

    EwButton(EwWindow* parent = 0);
    EwButton(int x, int y, int width, int height, EwWindow* parent = 0);


    void setText(const char* text);
    void getText(char* pBuf, int bufSz);

    ewColor_t getBackgroundColor(ewButtonColorIndex_t idx);
    void setBackgroundColor(ewButtonColorIndex_t idx, ewColor_t c);
    const ewFont_t* getFont();
    void setFont(const ewFont_t* pFont);

    ewTextAlign_t getTextAlign();
    void setTextAlign(ewTextAlign_t align);
    ewColor_t getTextColor(ewButtonColorIndex_t idx);
    void setTextColor(ewButtonColorIndex_t idx, ewColor_t c);

    void setFocusColor(ewColor_t c);
    void setFocussable(bool focussable);
    void setPressed(bool pressed);
    bool isPressed();

    void setTextOffset(int32_t xPos, int32_t yPos);

    const ewBitmap_t* getBitmap(ewButtonColorIndex_t idx);
    void setBitmap(ewButtonColorIndex_t idx, const ewBitmap_t* pBitmap);
    void setBitmap(ewButtonColorIndex_t idx, const ewBitmap_t* pBitmap, int32_t x, int32_t y);

    /**
     * Register a member function that will called when the button
     * is pressed.
     *
     * @param tptr pointer to the object to call the member function on
     * @param mptr pointer to the member function to be called
     */
    template<typename T>
    void setPressedListener(T* tptr, void (T::*mptr)(EwWindow* w)) {
        if((mptr != NULL) && (tptr != NULL)) {
            _pressedListener.attach(tptr, mptr);
        }
    }

    /**
     * Register a function that will called when the button
     * is pressed.
     *
     * @param fptr A pointer to a void function that will be called
     * when the button is pressed
     */
    void setPressedListener(void (*fptr)(EwWindow* w));

    /**
     * Register a member function that will called when the button
     * is released.
     *
     * @param tptr pointer to the object to call the member function on
     * @param mptr pointer to the member function to be called
     */
    template<typename T>
    void setReleasedListener(T* tptr, void (T::*mptr)(EwWindow* w)) {
        if((mptr != NULL) && (tptr != NULL)) {
            _releasedListener.attach(tptr, mptr);
        }
    }

    /**
     * Register a function that will called when the button
     * is released.
     *
     * @param fptr A pointer to a void function that will be called
     * when the button is released
     */
    void setReleasedListener(void (*fptr)(EwWindow* w));

    /**
     * Register a member function that will called when the button
     * is clicked.
     *
     * @param tptr pointer to the object to call the member function on
     * @param mptr pointer to the member function to be called
     */
    template<typename T>
    void setClickedListener(T* tptr, void (T::*mptr)(EwWindow* w)) {
        if((mptr != NULL) && (tptr != NULL)) {
            _clickedListener.attach(tptr, mptr);
        }
    }

    /**
     * Register a function that will called when the button
     * is clicked.
     *
     * @param fptr A pointer to a void function that will be called
     * when the button is clicked
     */
    void setClickedListener(void (*fptr)(EwWindow* w));

    static ewColor_t getDefaultBackgroundColor(ewButtonColorIndex_t idx);
    static void setDefaultBackgroundColor(ewButtonColorIndex_t idx, ewColor_t c);
    static const ewFont_t* getDefaultFont();
    static void setDefaultFont(const ewFont_t* pFont);
    static ewTextAlign_t getDefaultTextAlign();
    static void setDefaultTextAlign(ewTextAlign_t align);
    static ewColor_t getDefaultTextColor(ewButtonColorIndex_t idx);
    static void setDefaultTextColor(ewButtonColorIndex_t idx, ewColor_t c);

    static void setDefaultFocusColor(ewColor_t c);




private:

    bool _inputStatePressed;
    EwFunctionPointer _pressedListener;
    EwFunctionPointer _releasedListener;
    EwFunctionPointer _clickedListener;

    void init(int x, int y, int width, int height, EwWindow* parent);
    void handleInput(bool pressed, bool onWidget);

    static void _callback(WM_MESSAGE* pMsg, EwWindow* w);


};

#endif
