
#ifndef EWWINDOW_H
#define EWWINDOW_H

#include "EwPainter.h"

#include "GUI.h"
#include "WM.h"
#include "FRAMEWIN.h"

enum EwTouchState_t {
    TouchStatePressed = 0,
    TouchStateReleased,
    TouchStateReleasedOutside
};

/**
 * This is base class for all EwGui wrapper classes. It is related to
 * the emwin WM interface.
 */
class EwWindow {
public:

    EwWindow(EwWindow* parent = 0);
    EwWindow(int x, int y, int width, int height, EwWindow* parent = 0);
    ~EwWindow();

    void setParent(EwWindow* parent);
    void bringToBottom();
    void bringToTop();
    void disable();
    void enable();
    bool hasTransparency();
    int getX();
    int getY();
    int getWidth();
    int getHeight();
    bool hasInput();
    bool hasFocus();
    bool getStayOnTop();

    void hide();
    void invalidate();

    bool isCompletelyCovered();
    bool isCompletelyVisible();
    bool isEnabled();
    bool isVisible();

    void makeModal();
    void moveTo(int x, int y);
    void moveToAbs(int x, int y);
    void move(int dx, int dy);

    void repaint();
    void repaintAll();

    void resize(int dx, int dy);
    void resizeTo(int width, int height);
    void setFocus();
    void setHasTransparency(bool hasTrans);
    void setStayOnTop(bool onTop);

    void show();
    void update();
    void updateAll();

    static ewColor_t setDesktopColor(ewColor_t c);

    virtual bool paintEvent();
    virtual bool touchEvent(int x, int y, EwTouchState_t state);
    virtual bool focusEvent(bool gotFocus);
    virtual bool resizedEvent();

protected:
    GUI_HWIN _hWnd;
    static int _guiWidgetId;


    void _setNewHandle(GUI_HWIN hWnd, void (*callbackFunc)(WM_MESSAGE* pMsg, EwWindow* w));
    GUI_HWIN _getHandle(EwWindow* w);

private:


    void init(int x, int y, int width, int height, EwWindow* parent);

};

#endif
