
#ifndef EWDROPDOWN_H
#define EWDROPDOWN_H

#include "EwPainter.h"
#include "EwWindow.h"
#include "EwFunctionPointer.h"

#include "DROPDOWN.h"

// TODO: move to EwScrollbar.h ----------------->
#include "SCROLLBAR.h"

enum ewScrollBarColorIndex_t {
    ScrollBarColorIndexThumb = SCROLLBAR_CI_THUMB,
    ScrollBarColorIndexShaft = SCROLLBAR_CI_SHAFT,
    ScrollBarColorIndexArrow = SCROLLBAR_CI_ARROW,
};
// <---------------------------------------------

enum ewDropDownColorIndex_t {
    DropDownColorIndexUnselected = DROPDOWN_CI_UNSEL,
    DropDownColorIndexSelected = DROPDOWN_CI_SEL,
    DropDownColorIndexSelFocus = DROPDOWN_CI_SELFOCUS,
};

/**
 * This is a wrapper class for the emwin DROPDOWN interface.
 */
class EwDropDown : public EwWindow {
public:

    EwDropDown(EwWindow* parent = 0);
    EwDropDown(int x, int y, int width, int height, EwWindow* parent = 0);


    void addString(const char* s);
    void collapse();
    void decrementSelection();
    void deleteItem(uint32_t idx);
    void expand();
    bool isItemDisabled(uint32_t idx);
    bool getItemText(uint32_t idx, char* pBuffer, int maxSize);
    int getNumItems();
    int32_t getSelectedIndex();
    void incrementSelection();
    void insertString(const char* s, uint32_t idx);
    void setAutoScroll(bool on);
    void setBackgroundColor(ewDropDownColorIndex_t idx, ewColor_t c);
    void setColor(ewDropDownColorIndex_t idx, ewColor_t c);
    void setFont(const ewFont_t* pFont);
    void setItemEnableState(uint32_t idx, bool enabled);
    void setScrollbarColor(ewScrollBarColorIndex_t idx, ewColor_t c);
    void setScrollbarWidth(uint32_t width);
    void setSelectedItem(int32_t idx);
    void setItemSpacing(uint32_t spacing);
    void setTextAlign(ewTextAlign_t align);
    void setTextColor(ewDropDownColorIndex_t idx, ewColor_t c);
    void setTextHeight(uint32_t height);
    void setUpMode(bool upMode);

    /**
     * Register a member function that will called when a selection
     * in the drop-down list has changed.
     *
     * @param tptr pointer to the object to call the member function on
     * @param mptr pointer to the member function to be called
     */
    template<typename T>
    void setSelectionChangedListener(T* tptr, void (T::*mptr)(EwWindow* w)) {
        if((mptr != NULL) && (tptr != NULL)) {
            _selChangedListener.attach(tptr, mptr);
        }
    }

    /**
     * Register a function that will called when the a selection
     * in the drop-down list has changed.
     *
     * @param fptr A pointer to a void function that will be called
     */
    void setSelectionChangedListener(void (*fptr)(EwWindow* w));

    static ewColor_t getDefaultBackgroundColor(ewDropDownColorIndex_t idx);
    static ewColor_t getDefaultColor(ewDropDownColorIndex_t idx);
    static ewColor_t getDefaultScrollbarColor(ewDropDownColorIndex_t idx);
    static const ewFont_t* getDefaultFont();

    void setDefaultBackgroundColor(ewDropDownColorIndex_t idx, ewColor_t c);
    static void setDefaultColor(ewDropDownColorIndex_t idx, ewColor_t c);
    static void setDefaultFont(const ewFont_t* pFont);
    static void setDefaultScrollbarColor(ewScrollBarColorIndex_t idx, ewColor_t c);

private:

    EwFunctionPointer _selChangedListener;

    void init(int x, int y, int width, int height, EwWindow* parent);
    void handleSelectionChanged();

    static void _callback(WM_MESSAGE* pMsg, EwWindow* w);


};

#endif
