
#ifndef EWCHECKBOX_H
#define EWCHECKBOX_H

#include "EwPainter.h"
#include "EwWindow.h"
#include "EwFunctionPointer.h"

#include "CHECKBOX.h"

enum ewCheckBoxColorIndex_t {
    CheckBoxColorIndexDisabled = CHECKBOX_CI_DISABLED,
    CheckBoxColorIndexEnabled = CHECKBOX_CI_ENABLED,
};

enum ewCheckBoxBitmapIndex_t {
    CheckBoxBitmapInactiveUnchecked = CHECKBOX_BI_INACTIV_UNCHECKED,
    CheckBoxBitmapActiveUnchecked = CHECKBOX_BI_ACTIV_UNCHECKED,
    CheckBoxBitmapInactiveChecked = CHECKBOX_BI_INACTIV_CHECKED,
    CheckBoxBitmapActiveChecked = CHECKBOX_BI_ACTIV_CHECKED,
    CheckBoxBitmapInactive3State = CHECKBOX_BI_INACTIV_3STATE,
    CheckBoxBitmapActive3State = CHECKBOX_BI_ACTIV_3STATE
};

enum ewCheckBoxState_t {
    CheckBoxStateUnchecked = 0,
    CheckBoxStateChecked,
    CheckBoxStateTristate
};

/**
 * This is wrapper class for the emwin CHECKBOX interface.
 */
class EwCheckBox : public EwWindow {
public:

    EwCheckBox(EwWindow* parent = 0);
    EwCheckBox(int x, int y, int width, int height, EwWindow* parent = 0);




    ewCheckBoxState_t getState();
    void setState(ewCheckBoxState_t state);

    void setTristate(bool on = true);
    bool isTristate();

    void setText(const char* text);
    void getText(char* pBuf, int bufSz);

    void setBackgroundColor(ewColor_t c);
    void setBoxBackgroundColor(ewColor_t c, ewCheckBoxColorIndex_t idx);
    void setFont(const ewFont_t* pFont);

    void setTextAlign(ewTextAlign_t align);
    void setTextColor(ewColor_t c);

    void setFocusColor(ewColor_t c);

    void setImage(ewBitmap_t* pBitmap, ewCheckBoxBitmapIndex_t idx);
    void setSpacing(int32_t spacing);

    /**
     * Register a member function that will called when the checkbox
     * state has changed
     *
     * @param tptr pointer to the object to call the member function on
     * @param mptr pointer to the member function to be called
     */
    template<typename T>
    void setChangedListener(T* tptr, void (T::*mptr)(EwWindow* w)) {
        if((mptr != NULL) && (tptr != NULL)) {
            _changedListener.attach(tptr, mptr);
        }
    }

    /**
     * Register a function that will called when the checkbox
     * state has changed
     *
     * @param fptr A pointer to a void function that will be called
     * when the checkbox state has changed
     */
    void setChangedListener(void (*fptr)(EwWindow* w));


    static ewColor_t getDefaultBackgroundColor();
    static void setDefaultBackgroundColor(ewColor_t c);
    static const ewFont_t* getDefaultFont();
    static void setDefaultFont(const ewFont_t* pFont);
    static ewColor_t getDefaultTextColor();
    static void setDefaultTextColor(ewColor_t c);
    static void setDefaultFocusColor(ewColor_t c);

    static int32_t getDefaultSpacing();
    static void setDefaultSpacing(int32_t spacing);

    static void setDefaultImage(ewBitmap_t* pBitmap, ewCheckBoxBitmapIndex_t idx);


private:


    bool _isTristate;
    EwFunctionPointer _changedListener;

    void init(int x, int y, int width, int height, EwWindow* parent);
    void handleStateChanged();

    static void _callback(WM_MESSAGE* pMsg, EwWindow* w);


};

#endif
