/******************************************************************************
 * Includes
 *****************************************************************************/

#include "mbed.h"

#include "LcdController.h"
#include "EaLcdBoard.h"
#include "sdram.h"

#include "BubbleDemo.h"
#include "EthernetInterface.h"
#include "TCPSocketConnection.h"
#include "cmsis_os.h"


/******************************************************************************
 * Typedefs and defines
 *****************************************************************************/

#define RESET_FLAG  \
  do { \
    if (abortTest) { \
      abortTest = false; \
      wait(0.04); \
    } \
  } while(false)

/******************************************************************************
 * Local variables
 *****************************************************************************/

static InterruptIn buttonInterrupt(P2_10);
static DigitalOut led(LED1);
static DigitalOut led3(LED3);

static BubbleDemo* bubbleDemo;

/******************************************************************************
 * Global variables
 *****************************************************************************/

EaLcdBoard lcdBoard(P0_27, P0_28);
bool abortTest = false;

/******************************************************************************
 * Interrupt functions
 *****************************************************************************/

void trigger() {
    abortTest = true;
}

/******************************************************************************
 * Main
 *****************************************************************************/

void bubble_thread(void const *argument) {
    while (true) {
        bubbleDemo->run(750, 20);
        RESET_FLAG;
    }
}
void net_thread(void const *argument) {
    EthernetInterface eth;
    eth.init(); //Use DHCP
    eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress());
    TCPSocketConnection sock;
    while (true) {
        led3 = !led3;
        sock.connect("mbed.org", 80);
        sock.set_blocking(false, 3000);
 
        char http_cmd[] = "GET /media/uploads/donatien/hello.txt HTTP/1.1\r\nHost: %s\r\n\r\n";
        printf("sending:\n---\n%s\n---\n", http_cmd);
        sock.send(http_cmd, sizeof(http_cmd) - 1);//, 3000);
 
        char in_buf[256];
        bool firstIteration = true;
        int ret;
        do {
            printf("reading...\n");
            ret = sock.receive(in_buf, 255);//, firstIteration?3000:0);
            in_buf[ret] = '\0';
 
            printf("Received %d chars from server: %s\n", ret, in_buf);
            firstIteration = false;
        } while ( ret == 255 ); // once we get less that full buffer we know all data has been received
//        } while ( ret > 0 );
 
        sock.close();
 
        //eth.disconnect();
 
        led3 = !led3;
        osDelay(500);
    }
}
 
osThreadDef(bubble_thread, osPriorityNormal, DEFAULT_STACK_SIZE);
osThreadDef(net_thread, osPriorityNormal, DEFAULT_STACK_SIZE);
 
int main (void) {    

    EaLcdBoard::Result result;
    LcdController::Config lcdCfg;
    uint32_t frameBuf1 = (uint32_t) SDRAM_BASE;

    printf("Simple example of using network (HTTP GET) and LCD at the same time\n");

    // Listen for button presses
    buttonInterrupt.mode(PullUp);
    buttonInterrupt.fall(&trigger);

    do {
        // framebuffer is put in SDRAM
        if (sdram_init() == 1) {
            printf("Failed to initialize SDRAM\n");
            break;
        }

        result = lcdBoard.open(NULL, NULL);
        if (result != EaLcdBoard::Ok) {
            printf("Failed to open display: %d\n", result);
            break;
        }

        result = lcdBoard.setFrameBuffer(frameBuf1);
        if (result != EaLcdBoard::Ok) {
            printf("Failed to activate frameBuffer: %d\n", result);
            break;
        }

        result = lcdBoard.getLcdConfig(&lcdCfg);
        if (result != EaLcdBoard::Ok) {
            printf("Failed to get LCD configuration: %d\n", result);
            break;
        }
        
        // Prepare 3 consequtive framebuffers (2 will be used for background buffers)
        memset((void*)frameBuf1, 0x0, lcdCfg.width*lcdCfg.height*2 *3);

        bubbleDemo = new BubbleDemo((uint8_t *)frameBuf1, lcdCfg.width, lcdCfg.height);    
        osThreadCreate(osThread(bubble_thread), NULL);
     
        osThreadCreate(osThread(net_thread), NULL);
     
        while (true) {
            led = 0;
            wait(0.1);
            led = 1;
            wait(0.5);
        }
    } while(0);

    // Blink to indicate error
    while (1) {
        led = 0;
        wait(0.2);
        led = 1;
        wait(0.2);
    }
}
