/*****************************************************************************
 *
 *   Copyright(C) 2011, Embedded Artists AB
 *   All rights reserved.
 *
 ******************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * Embedded Artists AB assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. Embedded Artists AB
 * reserves the right to make changes in the software without
 * notification. Embedded Artists AB also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 *****************************************************************************/



/******************************************************************************
 * Includes
 *****************************************************************************/

#include "mbed.h"
#include "crc.h"


/******************************************************************************
 * Defines and typedefs
 *****************************************************************************/

#define NUM_CRC_BUFF_ENTRIES  (100)

#define CRC32_INIT()  do { LPC_CRC->MODE = 0x00000036; LPC_CRC->SEED = 0xffffffff; } while(0)

#define CRC32_WRITE8(__val)   LPC_CRC->WR_DATA_BYTE.DATA = (uint8_t)(__val)
#define CRC32_WRITE16(__val)  LPC_CRC->WR_DATA_WORD.DATA = (uint16_t)(__val)
#define CRC32_WRITE32(__val)  LPC_CRC->WR_DATA_DWORD.DATA = (__val)

#define CRC32_SUM()           LPC_CRC->SUM

/******************************************************************************
 * External global variables
 *****************************************************************************/

/******************************************************************************
 * Local variables
 *****************************************************************************/

static uint32_t crcbuff[NUM_CRC_BUFF_ENTRIES];

/******************************************************************************
 * Local Functions
 *****************************************************************************/


/******************************************************************************
 * Public Functions
 *****************************************************************************/

uint32_t crc_Read(FILE* f)
{  
  CRC32_INIT();
  fseek(f, 0, SEEK_SET);
  memset(crcbuff, 0, sizeof(uint32_t)*NUM_CRC_BUFF_ENTRIES);
  int numRead = fread(crcbuff, sizeof(uint32_t), 100, f);
  while (numRead > 0) {
    for (int i = 0; i < numRead; i++) {
      CRC32_WRITE32(crcbuff[i]);
    }
    numRead = fread(crcbuff, sizeof(uint32_t), 100, f);
  }
  return CRC32_SUM();
}

